///////////////////////////////////////////////////////
//  Copyright (c) 2009 Xilinx Inc.
//  All Right Reserved.
///////////////////////////////////////////////////////
//
//   ____   ___
//  /   /\/   / 
// /___/  \  /     Vendor      : Xilinx 
// \  \    \/      Version     : 11.4
//  \  \           Description : Xilinx Functional Simulation Library Component
//  /  /                       : Tri-Mode Ethernet MAC
// /__/   /\       Filename    : X_TEMAC_SINGLE.v
// \  \  /  \      
//  \__\/\__ \                    
//                                 
//  Revision:
//  11/05/07 - - CR453443 - Initial version.
//  05/30/08 - CR1014 - Added parameter
//  08/05/08 - CR1014 - EMAC_DCRBASEADDR updated from [7:0] to [0:7]
//  09/23/08 - CR490335 - Checkin complete verilog simprim
//  10/13/08 - CR492334 - update X_TEMAC_SINGLE_INST to B_TEMAC_SINGLE_INST
//  10/24/08 - CR1014 - Added glbl.GSR
//  11/05/08 - CR495127 - $recrem specify section
//  11/11/08 - CR493972 - Add SIM_VERSION
//  01/27/09 - CR505569 - Writer update
//  03/18/09 - CR511472 - Update assign section for input CLK ports which are not present in setuphold/recrem section
//  04/03/09 - CR515882 - Fix for 16 bit client mode
//  09/01/09 - CR532335 - Delay YML update, specify block update
//  10/16/09 - CR535122 - PHYEMACMIITXCLK assign section update for 16-bit client
/////////////////////////////////////////////////////////

`timescale 1 ps / 1 ps 

module X_TEMAC_SINGLE (
  DCRHOSTDONEIR,
  EMACCLIENTANINTERRUPT,
  EMACCLIENTRXBADFRAME,
  EMACCLIENTRXCLIENTCLKOUT,
  EMACCLIENTRXD,
  EMACCLIENTRXDVLD,
  EMACCLIENTRXDVLDMSW,
  EMACCLIENTRXFRAMEDROP,
  EMACCLIENTRXGOODFRAME,
  EMACCLIENTRXSTATS,
  EMACCLIENTRXSTATSBYTEVLD,
  EMACCLIENTRXSTATSVLD,
  EMACCLIENTTXACK,
  EMACCLIENTTXCLIENTCLKOUT,
  EMACCLIENTTXCOLLISION,
  EMACCLIENTTXRETRANSMIT,
  EMACCLIENTTXSTATS,
  EMACCLIENTTXSTATSBYTEVLD,
  EMACCLIENTTXSTATSVLD,
  EMACDCRACK,
  EMACDCRDBUS,
  EMACPHYENCOMMAALIGN,
  EMACPHYLOOPBACKMSB,
  EMACPHYMCLKOUT,
  EMACPHYMDOUT,
  EMACPHYMDTRI,
  EMACPHYMGTRXRESET,
  EMACPHYMGTTXRESET,
  EMACPHYPOWERDOWN,
  EMACPHYSYNCACQSTATUS,
  EMACPHYTXCHARDISPMODE,
  EMACPHYTXCHARDISPVAL,
  EMACPHYTXCHARISK,
  EMACPHYTXCLK,
  EMACPHYTXD,
  EMACPHYTXEN,
  EMACPHYTXER,
  EMACPHYTXGMIIMIICLKOUT,
  EMACSPEEDIS10100,
  HOSTMIIMRDY,
  HOSTRDDATA,
  CLIENTEMACDCMLOCKED,
  CLIENTEMACPAUSEREQ,
  CLIENTEMACPAUSEVAL,
  CLIENTEMACRXCLIENTCLKIN,
  CLIENTEMACTXCLIENTCLKIN,
  CLIENTEMACTXD,
  CLIENTEMACTXDVLD,
  CLIENTEMACTXDVLDMSW,
  CLIENTEMACTXFIRSTBYTE,
  CLIENTEMACTXIFGDELAY,
  CLIENTEMACTXUNDERRUN,
  DCREMACABUS,
  DCREMACCLK,
  DCREMACDBUS,
  DCREMACENABLE,
  DCREMACREAD,
  DCREMACWRITE,
  HOSTADDR,
  HOSTCLK,
  HOSTMIIMSEL,
  HOSTOPCODE,
  HOSTREQ,
  HOSTWRDATA,
  PHYEMACCOL,
  PHYEMACCRS,
  PHYEMACGTXCLK,
  PHYEMACMCLKIN,
  PHYEMACMDIN,
  PHYEMACMIITXCLK,
  PHYEMACPHYAD,
  PHYEMACRXBUFSTATUS,
  PHYEMACRXCHARISCOMMA,
  PHYEMACRXCHARISK,
  PHYEMACRXCLK,
  PHYEMACRXCLKCORCNT,
  PHYEMACRXD,
  PHYEMACRXDISPERR,
  PHYEMACRXDV,
  PHYEMACRXER,
  PHYEMACRXNOTINTABLE,
  PHYEMACRXRUNDISP,
  PHYEMACSIGNALDET,
  PHYEMACTXBUFERR,
  PHYEMACTXGMIIMIICLKIN,
  RESET
);
  
  parameter LOC = "UNPLACED";
  parameter EMAC_1000BASEX_ENABLE = "FALSE";
  parameter EMAC_ADDRFILTER_ENABLE = "FALSE";
  parameter EMAC_BYTEPHY = "FALSE";
  parameter EMAC_CTRLLENCHECK_DISABLE = "FALSE";
  parameter [0:7] EMAC_DCRBASEADDR = 8'h00;
  parameter EMAC_GTLOOPBACK = "FALSE";
  parameter EMAC_HOST_ENABLE = "FALSE";
  parameter [8:0] EMAC_LINKTIMERVAL = 9'h000;
  parameter EMAC_LTCHECK_DISABLE = "FALSE";
  parameter EMAC_MDIO_ENABLE = "FALSE";
  parameter EMAC_MDIO_IGNORE_PHYADZERO = "FALSE";
  parameter [47:0] EMAC_PAUSEADDR = 48'h000000000000;
  parameter EMAC_PHYINITAUTONEG_ENABLE = "FALSE";
  parameter EMAC_PHYISOLATE = "FALSE";
  parameter EMAC_PHYLOOPBACKMSB = "FALSE";
  parameter EMAC_PHYPOWERDOWN = "FALSE";
  parameter EMAC_PHYRESET = "FALSE";
  parameter EMAC_RGMII_ENABLE = "FALSE";
  parameter EMAC_RX16BITCLIENT_ENABLE = "FALSE";
  parameter EMAC_RXFLOWCTRL_ENABLE = "FALSE";
  parameter EMAC_RXHALFDUPLEX = "FALSE";
  parameter EMAC_RXINBANDFCS_ENABLE = "FALSE";
  parameter EMAC_RXJUMBOFRAME_ENABLE = "FALSE";
  parameter EMAC_RXRESET = "FALSE";
  parameter EMAC_RXVLAN_ENABLE = "FALSE";
  parameter EMAC_RX_ENABLE = "TRUE";
  parameter EMAC_SGMII_ENABLE = "FALSE";
  parameter EMAC_SPEED_LSB = "FALSE";
  parameter EMAC_SPEED_MSB = "FALSE";
  parameter EMAC_TX16BITCLIENT_ENABLE = "FALSE";
  parameter EMAC_TXFLOWCTRL_ENABLE = "FALSE";
  parameter EMAC_TXHALFDUPLEX = "FALSE";
  parameter EMAC_TXIFGADJUST_ENABLE = "FALSE";
  parameter EMAC_TXINBANDFCS_ENABLE = "FALSE";
  parameter EMAC_TXJUMBOFRAME_ENABLE = "FALSE";
  parameter EMAC_TXRESET = "FALSE";
  parameter EMAC_TXVLAN_ENABLE = "FALSE";
  parameter EMAC_TX_ENABLE = "TRUE";
  parameter [47:0] EMAC_UNICASTADDR = 48'h000000000000;
  parameter EMAC_UNIDIRECTION_ENABLE = "FALSE";
  parameter EMAC_USECLKEN = "FALSE";
  parameter SIM_VERSION = "1.0";
  
  localparam in_delay = 50;
  localparam out_delay = 0;
  localparam INCLK_DELAY = 0;
  localparam OUTCLK_DELAY = 0;

  localparam EMACMIITXCLK_DELAY = (EMAC_TX16BITCLIENT_ENABLE == "TRUE") ? 25: INCLK_DELAY;

  output DCRHOSTDONEIR;
  output EMACCLIENTANINTERRUPT;
  output EMACCLIENTRXBADFRAME;
  output EMACCLIENTRXCLIENTCLKOUT;
  output EMACCLIENTRXDVLD;
  output EMACCLIENTRXDVLDMSW;
  output EMACCLIENTRXFRAMEDROP;
  output EMACCLIENTRXGOODFRAME;
  output EMACCLIENTRXSTATSBYTEVLD;
  output EMACCLIENTRXSTATSVLD;
  output EMACCLIENTTXACK;
  output EMACCLIENTTXCLIENTCLKOUT;
  output EMACCLIENTTXCOLLISION;
  output EMACCLIENTTXRETRANSMIT;
  output EMACCLIENTTXSTATS;
  output EMACCLIENTTXSTATSBYTEVLD;
  output EMACCLIENTTXSTATSVLD;
  output EMACDCRACK;
  output EMACPHYENCOMMAALIGN;
  output EMACPHYLOOPBACKMSB;
  output EMACPHYMCLKOUT;
  output EMACPHYMDOUT;
  output EMACPHYMDTRI;
  output EMACPHYMGTRXRESET;
  output EMACPHYMGTTXRESET;
  output EMACPHYPOWERDOWN;
  output EMACPHYSYNCACQSTATUS;
  output EMACPHYTXCHARDISPMODE;
  output EMACPHYTXCHARDISPVAL;
  output EMACPHYTXCHARISK;
  output EMACPHYTXCLK;
  output EMACPHYTXEN;
  output EMACPHYTXER;
  output EMACPHYTXGMIIMIICLKOUT;
  output EMACSPEEDIS10100;
  output HOSTMIIMRDY;
  output [0:31] EMACDCRDBUS;
  output [15:0] EMACCLIENTRXD;
  output [31:0] HOSTRDDATA;
  output [6:0] EMACCLIENTRXSTATS;
  output [7:0] EMACPHYTXD;

  input CLIENTEMACDCMLOCKED;
  input CLIENTEMACPAUSEREQ;
  input CLIENTEMACRXCLIENTCLKIN;
  input CLIENTEMACTXCLIENTCLKIN;
  input CLIENTEMACTXDVLD;
  input CLIENTEMACTXDVLDMSW;
  input CLIENTEMACTXFIRSTBYTE;
  input CLIENTEMACTXUNDERRUN;
  input DCREMACCLK;
  input DCREMACENABLE;
  input DCREMACREAD;
  input DCREMACWRITE;
  input HOSTCLK;
  input HOSTMIIMSEL;
  input HOSTREQ;
  input PHYEMACCOL;
  input PHYEMACCRS;
  input PHYEMACGTXCLK;
  input PHYEMACMCLKIN;
  input PHYEMACMDIN;
  input PHYEMACMIITXCLK;
  input PHYEMACRXCHARISCOMMA;
  input PHYEMACRXCHARISK;
  input PHYEMACRXCLK;
  input PHYEMACRXDISPERR;
  input PHYEMACRXDV;
  input PHYEMACRXER;
  input PHYEMACRXNOTINTABLE;
  input PHYEMACRXRUNDISP;
  input PHYEMACSIGNALDET;
  input PHYEMACTXBUFERR;
  input PHYEMACTXGMIIMIICLKIN;
  input RESET;
  input [0:31] DCREMACDBUS;
  input [0:9] DCREMACABUS;
  input [15:0] CLIENTEMACPAUSEVAL;
  input [15:0] CLIENTEMACTXD;
  input [1:0] HOSTOPCODE;
  input [1:0] PHYEMACRXBUFSTATUS;
  input [2:0] PHYEMACRXCLKCORCNT;
  input [31:0] HOSTWRDATA;
  input [4:0] PHYEMACPHYAD;
  input [7:0] CLIENTEMACTXIFGDELAY;
  input [7:0] PHYEMACRXD;
  input [9:0] HOSTADDR;
  reg EMAC_1000BASEX_ENABLE_BINARY;
  reg EMAC_ADDRFILTER_ENABLE_BINARY;
  reg EMAC_BYTEPHY_BINARY;
  reg EMAC_CTRLLENCHECK_DISABLE_BINARY;
  reg EMAC_GTLOOPBACK_BINARY;
  reg EMAC_HOST_ENABLE_BINARY;
  reg EMAC_LTCHECK_DISABLE_BINARY;
  reg EMAC_MDIO_ENABLE_BINARY;
  reg EMAC_MDIO_IGNORE_PHYADZERO_BINARY;
  reg EMAC_PHYINITAUTONEG_ENABLE_BINARY;
  reg EMAC_PHYISOLATE_BINARY;
  reg EMAC_PHYLOOPBACKMSB_BINARY;
  reg EMAC_PHYPOWERDOWN_BINARY;
  reg EMAC_PHYRESET_BINARY;
  reg EMAC_RGMII_ENABLE_BINARY;
  reg EMAC_RX16BITCLIENT_ENABLE_BINARY;
  reg EMAC_RXFLOWCTRL_ENABLE_BINARY;
  reg EMAC_RXHALFDUPLEX_BINARY;
  reg EMAC_RXINBANDFCS_ENABLE_BINARY;
  reg EMAC_RXJUMBOFRAME_ENABLE_BINARY;
  reg EMAC_RXRESET_BINARY;
  reg EMAC_RXVLAN_ENABLE_BINARY;
  reg EMAC_RX_ENABLE_BINARY;
  reg EMAC_SGMII_ENABLE_BINARY;
  reg EMAC_SPEED_LSB_BINARY;
  reg EMAC_SPEED_MSB_BINARY;
  reg EMAC_TX16BITCLIENT_ENABLE_BINARY;
  reg EMAC_TXFLOWCTRL_ENABLE_BINARY;
  reg EMAC_TXHALFDUPLEX_BINARY;
  reg EMAC_TXIFGADJUST_ENABLE_BINARY;
  reg EMAC_TXINBANDFCS_ENABLE_BINARY;
  reg EMAC_TXJUMBOFRAME_ENABLE_BINARY;
  reg EMAC_TXRESET_BINARY;
  reg EMAC_TXVLAN_ENABLE_BINARY;
  reg EMAC_TX_ENABLE_BINARY;
  reg EMAC_UNIDIRECTION_ENABLE_BINARY;
  reg EMAC_USECLKEN_BINARY;
  reg SIM_VERSION_BINARY;

  tri0 GSR = glbl.GSR;
  reg notifier;

  wire DCRHOSTDONEIR_OUT;
  wire EMACCLIENTANINTERRUPT_OUT;
  wire EMACCLIENTRXBADFRAME_OUT;
  wire EMACCLIENTRXCLIENTCLKOUT_OUT;
  wire EMACCLIENTRXDVLDMSW_OUT;
  wire EMACCLIENTRXDVLD_OUT;
  wire EMACCLIENTRXFRAMEDROP_OUT;
  wire EMACCLIENTRXGOODFRAME_OUT;
  wire EMACCLIENTRXSTATSBYTEVLD_OUT;
  wire EMACCLIENTRXSTATSVLD_OUT;
  wire EMACCLIENTTXACK_OUT;
  wire EMACCLIENTTXCLIENTCLKOUT_OUT;
  wire EMACCLIENTTXCOLLISION_OUT;
  wire EMACCLIENTTXRETRANSMIT_OUT;
  wire EMACCLIENTTXSTATSBYTEVLD_OUT;
  wire EMACCLIENTTXSTATSVLD_OUT;
  wire EMACCLIENTTXSTATS_OUT;
  wire EMACDCRACK_OUT;
  wire EMACPHYENCOMMAALIGN_OUT;
  wire EMACPHYLOOPBACKMSB_OUT;
  wire EMACPHYMCLKOUT_OUT;
  wire EMACPHYMDOUT_OUT;
  wire EMACPHYMDTRI_OUT;
  wire EMACPHYMGTRXRESET_OUT;
  wire EMACPHYMGTTXRESET_OUT;
  wire EMACPHYPOWERDOWN_OUT;
  wire EMACPHYSYNCACQSTATUS_OUT;
  wire EMACPHYTXCHARDISPMODE_OUT;
  wire EMACPHYTXCHARDISPVAL_OUT;
  wire EMACPHYTXCHARISK_OUT;
  wire EMACPHYTXCLK_OUT;
  wire EMACPHYTXEN_OUT;
  wire EMACPHYTXER_OUT;
  wire EMACPHYTXGMIIMIICLKOUT_OUT;
  wire EMACSPEEDIS10100_OUT;
  wire HOSTMIIMRDY_OUT;
  wire [0:31] EMACDCRDBUS_OUT;
  wire [15:0] EMACCLIENTRXD_OUT;
  wire [31:0] HOSTRDDATA_OUT;
  wire [6:0] EMACCLIENTRXSTATS_OUT;
  wire [7:0] EMACPHYTXD_OUT;

  wire CLIENTEMACDCMLOCKED_IN;
  wire CLIENTEMACPAUSEREQ_IN;
  wire CLIENTEMACRXCLIENTCLKIN_IN;
  wire CLIENTEMACTXCLIENTCLKIN_IN;
  wire CLIENTEMACTXDVLDMSW_IN;
  wire CLIENTEMACTXDVLD_IN;
  wire CLIENTEMACTXFIRSTBYTE_IN;
  wire CLIENTEMACTXUNDERRUN_IN;
  wire DCREMACCLK_IN;
  wire DCREMACENABLE_IN;
  wire DCREMACREAD_IN;
  wire DCREMACWRITE_IN;
  wire HOSTCLK_IN;
  wire HOSTMIIMSEL_IN;
  wire HOSTREQ_IN;
  wire PHYEMACCOL_IN;
  wire PHYEMACCRS_IN;
  wire PHYEMACGTXCLK_IN;
  wire PHYEMACMCLKIN_IN;
  wire PHYEMACMDIN_IN;
  wire PHYEMACMIITXCLK_IN;
  wire PHYEMACRXCHARISCOMMA_IN;
  wire PHYEMACRXCHARISK_IN;
  wire PHYEMACRXCLK_IN;
  wire PHYEMACRXDISPERR_IN;
  wire PHYEMACRXDV_IN;
  wire PHYEMACRXER_IN;
  wire PHYEMACRXNOTINTABLE_IN;
  wire PHYEMACRXRUNDISP_IN;
  wire PHYEMACSIGNALDET_IN;
  wire PHYEMACTXBUFERR_IN;
  wire PHYEMACTXGMIIMIICLKIN_IN;
  wire RESET_IN;
  wire [0:31] DCREMACDBUS_IN;
  wire [0:9] DCREMACABUS_IN;
  wire [15:0] CLIENTEMACPAUSEVAL_IN;
  wire [15:0] CLIENTEMACTXD_IN;
  wire [1:0] HOSTOPCODE_IN;
  wire [1:0] PHYEMACRXBUFSTATUS_IN;
  wire [2:0] PHYEMACRXCLKCORCNT_IN;
  wire [31:0] HOSTWRDATA_IN;
  wire [4:0] PHYEMACPHYAD_IN;
  wire [7:0] CLIENTEMACTXIFGDELAY_IN;
  wire [7:0] PHYEMACRXD_IN;
  wire [9:0] HOSTADDR_IN;

  wire CLIENTEMACDCMLOCKED_INDELAY;
  wire CLIENTEMACPAUSEREQ_INDELAY;
  wire CLIENTEMACRXCLIENTCLKIN_INDELAY;
  wire CLIENTEMACTXCLIENTCLKIN_INDELAY;
  wire CLIENTEMACTXDVLDMSW_INDELAY;
  wire CLIENTEMACTXDVLD_INDELAY;
  wire CLIENTEMACTXFIRSTBYTE_INDELAY;
  wire CLIENTEMACTXUNDERRUN_INDELAY;
  wire DCREMACCLK_INDELAY;
  wire DCREMACENABLE_INDELAY;
  wire DCREMACREAD_INDELAY;
  wire DCREMACWRITE_INDELAY;
  wire HOSTCLK_INDELAY;
  wire HOSTMIIMSEL_INDELAY;
  wire HOSTREQ_INDELAY;
  wire PHYEMACCOL_INDELAY;
  wire PHYEMACCRS_INDELAY;
  wire PHYEMACGTXCLK_INDELAY;
  wire PHYEMACMCLKIN_INDELAY;
  wire PHYEMACMDIN_INDELAY;
  wire PHYEMACMIITXCLK_INDELAY;
  wire PHYEMACRXCHARISCOMMA_INDELAY;
  wire PHYEMACRXCHARISK_INDELAY;
  wire PHYEMACRXCLK_INDELAY;
  wire PHYEMACRXDISPERR_INDELAY;
  wire PHYEMACRXDV_INDELAY;
  wire PHYEMACRXER_INDELAY;
  wire PHYEMACRXNOTINTABLE_INDELAY;
  wire PHYEMACRXRUNDISP_INDELAY;
  wire PHYEMACSIGNALDET_INDELAY;
  wire PHYEMACTXBUFERR_INDELAY;
  wire PHYEMACTXGMIIMIICLKIN_INDELAY;
  wire RESET_INDELAY;
  wire [0:31] DCREMACDBUS_INDELAY;
  wire [0:9] DCREMACABUS_INDELAY;
  wire [15:0] CLIENTEMACPAUSEVAL_INDELAY;
  wire [15:0] CLIENTEMACTXD_INDELAY;
  wire [1:0] HOSTOPCODE_INDELAY;
  wire [1:0] PHYEMACRXBUFSTATUS_INDELAY;
  wire [2:0] PHYEMACRXCLKCORCNT_INDELAY;
  wire [31:0] HOSTWRDATA_INDELAY;
  wire [4:0] PHYEMACPHYAD_INDELAY;
  wire [7:0] CLIENTEMACTXIFGDELAY_INDELAY;
  wire [7:0] PHYEMACRXD_INDELAY;
  wire [9:0] HOSTADDR_INDELAY;

  initial begin
    case (EMAC_1000BASEX_ENABLE)
      "FALSE" : EMAC_1000BASEX_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_1000BASEX_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_1000BASEX_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_1000BASEX_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_ADDRFILTER_ENABLE)
      "FALSE" : EMAC_ADDRFILTER_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_ADDRFILTER_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_ADDRFILTER_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_ADDRFILTER_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_BYTEPHY)
      "FALSE" : EMAC_BYTEPHY_BINARY = 1'b0;
      "TRUE" : EMAC_BYTEPHY_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_BYTEPHY on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_BYTEPHY);
        $finish;
      end
    endcase

    case (EMAC_CTRLLENCHECK_DISABLE)
      "FALSE" : EMAC_CTRLLENCHECK_DISABLE_BINARY = 1'b0;
      "TRUE" : EMAC_CTRLLENCHECK_DISABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_CTRLLENCHECK_DISABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_CTRLLENCHECK_DISABLE);
        $finish;
      end
    endcase

    case (EMAC_GTLOOPBACK)
      "FALSE" : EMAC_GTLOOPBACK_BINARY = 1'b0;
      "TRUE" : EMAC_GTLOOPBACK_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_GTLOOPBACK on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_GTLOOPBACK);
        $finish;
      end
    endcase

    case (EMAC_HOST_ENABLE)
      "FALSE" : EMAC_HOST_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_HOST_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_HOST_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_HOST_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_LTCHECK_DISABLE)
      "FALSE" : EMAC_LTCHECK_DISABLE_BINARY = 1'b0;
      "TRUE" : EMAC_LTCHECK_DISABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_LTCHECK_DISABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_LTCHECK_DISABLE);
        $finish;
      end
    endcase

    case (EMAC_MDIO_ENABLE)
      "FALSE" : EMAC_MDIO_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_MDIO_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_MDIO_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_MDIO_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_MDIO_IGNORE_PHYADZERO)
      "FALSE" : EMAC_MDIO_IGNORE_PHYADZERO_BINARY = 1'b0;
      "TRUE" : EMAC_MDIO_IGNORE_PHYADZERO_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_MDIO_IGNORE_PHYADZERO on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_MDIO_IGNORE_PHYADZERO);
        $finish;
      end
    endcase

    case (EMAC_PHYINITAUTONEG_ENABLE)
      "FALSE" : EMAC_PHYINITAUTONEG_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_PHYINITAUTONEG_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_PHYINITAUTONEG_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_PHYINITAUTONEG_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_PHYISOLATE)
      "FALSE" : EMAC_PHYISOLATE_BINARY = 1'b0;
      "TRUE" : EMAC_PHYISOLATE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_PHYISOLATE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_PHYISOLATE);
        $finish;
      end
    endcase

    case (EMAC_PHYLOOPBACKMSB)
      "FALSE" : EMAC_PHYLOOPBACKMSB_BINARY = 1'b0;
      "TRUE" : EMAC_PHYLOOPBACKMSB_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_PHYLOOPBACKMSB on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_PHYLOOPBACKMSB);
        $finish;
      end
    endcase

    case (EMAC_PHYPOWERDOWN)
      "FALSE" : EMAC_PHYPOWERDOWN_BINARY = 1'b0;
      "TRUE" : EMAC_PHYPOWERDOWN_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_PHYPOWERDOWN on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_PHYPOWERDOWN);
        $finish;
      end
    endcase

    case (EMAC_PHYRESET)
      "FALSE" : EMAC_PHYRESET_BINARY = 1'b0;
      "TRUE" : EMAC_PHYRESET_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_PHYRESET on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_PHYRESET);
        $finish;
      end
    endcase

    case (EMAC_RGMII_ENABLE)
      "FALSE" : EMAC_RGMII_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_RGMII_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_RGMII_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_RGMII_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_RX16BITCLIENT_ENABLE)
      "FALSE" : EMAC_RX16BITCLIENT_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_RX16BITCLIENT_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_RX16BITCLIENT_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_RX16BITCLIENT_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_RXFLOWCTRL_ENABLE)
      "FALSE" : EMAC_RXFLOWCTRL_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_RXFLOWCTRL_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_RXFLOWCTRL_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_RXFLOWCTRL_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_RXHALFDUPLEX)
      "FALSE" : EMAC_RXHALFDUPLEX_BINARY = 1'b0;
      "TRUE" : EMAC_RXHALFDUPLEX_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_RXHALFDUPLEX on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_RXHALFDUPLEX);
        $finish;
      end
    endcase

    case (EMAC_RXINBANDFCS_ENABLE)
      "FALSE" : EMAC_RXINBANDFCS_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_RXINBANDFCS_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_RXINBANDFCS_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_RXINBANDFCS_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_RXJUMBOFRAME_ENABLE)
      "FALSE" : EMAC_RXJUMBOFRAME_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_RXJUMBOFRAME_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_RXJUMBOFRAME_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_RXJUMBOFRAME_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_RXRESET)
      "FALSE" : EMAC_RXRESET_BINARY = 1'b0;
      "TRUE" : EMAC_RXRESET_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_RXRESET on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_RXRESET);
        $finish;
      end
    endcase

    case (EMAC_RXVLAN_ENABLE)
      "FALSE" : EMAC_RXVLAN_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_RXVLAN_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_RXVLAN_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_RXVLAN_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_RX_ENABLE)
      "FALSE" : EMAC_RX_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_RX_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_RX_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_RX_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_SGMII_ENABLE)
      "FALSE" : EMAC_SGMII_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_SGMII_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_SGMII_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_SGMII_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_SPEED_LSB)
      "FALSE" : EMAC_SPEED_LSB_BINARY = 1'b0;
      "TRUE" : EMAC_SPEED_LSB_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_SPEED_LSB on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_SPEED_LSB);
        $finish;
      end
    endcase

    case (EMAC_SPEED_MSB)
      "FALSE" : EMAC_SPEED_MSB_BINARY = 1'b0;
      "TRUE" : EMAC_SPEED_MSB_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_SPEED_MSB on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_SPEED_MSB);
        $finish;
      end
    endcase

    case (EMAC_TX16BITCLIENT_ENABLE)
      "FALSE" : EMAC_TX16BITCLIENT_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_TX16BITCLIENT_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_TX16BITCLIENT_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_TX16BITCLIENT_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_TXFLOWCTRL_ENABLE)
      "FALSE" : EMAC_TXFLOWCTRL_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_TXFLOWCTRL_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_TXFLOWCTRL_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_TXFLOWCTRL_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_TXHALFDUPLEX)
      "FALSE" : EMAC_TXHALFDUPLEX_BINARY = 1'b0;
      "TRUE" : EMAC_TXHALFDUPLEX_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_TXHALFDUPLEX on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_TXHALFDUPLEX);
        $finish;
      end
    endcase

    case (EMAC_TXIFGADJUST_ENABLE)
      "FALSE" : EMAC_TXIFGADJUST_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_TXIFGADJUST_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_TXIFGADJUST_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_TXIFGADJUST_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_TXINBANDFCS_ENABLE)
      "FALSE" : EMAC_TXINBANDFCS_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_TXINBANDFCS_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_TXINBANDFCS_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_TXINBANDFCS_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_TXJUMBOFRAME_ENABLE)
      "FALSE" : EMAC_TXJUMBOFRAME_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_TXJUMBOFRAME_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_TXJUMBOFRAME_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_TXJUMBOFRAME_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_TXRESET)
      "FALSE" : EMAC_TXRESET_BINARY = 1'b0;
      "TRUE" : EMAC_TXRESET_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_TXRESET on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_TXRESET);
        $finish;
      end
    endcase

    case (EMAC_TXVLAN_ENABLE)
      "FALSE" : EMAC_TXVLAN_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_TXVLAN_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_TXVLAN_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_TXVLAN_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_TX_ENABLE)
      "FALSE" : EMAC_TX_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_TX_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_TX_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_TX_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_UNIDIRECTION_ENABLE)
      "FALSE" : EMAC_UNIDIRECTION_ENABLE_BINARY = 1'b0;
      "TRUE" : EMAC_UNIDIRECTION_ENABLE_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_UNIDIRECTION_ENABLE on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_UNIDIRECTION_ENABLE);
        $finish;
      end
    endcase

    case (EMAC_USECLKEN)
      "FALSE" : EMAC_USECLKEN_BINARY = 1'b0;
      "TRUE" : EMAC_USECLKEN_BINARY = 1'b1;
      default : begin
        $display("Attribute Syntax Error : The Attribute EMAC_USECLKEN on X_TEMAC_SINGLE instance %m is set to %s.  Legal values for this attribute are TRUE or FALSE.", EMAC_USECLKEN);
        $finish;
      end
    endcase

  end

  buf B_DCRHOSTDONEIR (DCRHOSTDONEIR, DCRHOSTDONEIR_OUT);
  buf B_EMACCLIENTANINTERRUPT (EMACCLIENTANINTERRUPT, EMACCLIENTANINTERRUPT_OUT);
  buf B_EMACCLIENTRXBADFRAME (EMACCLIENTRXBADFRAME, EMACCLIENTRXBADFRAME_OUT);
  buf B_EMACCLIENTRXCLIENTCLKOUT (EMACCLIENTRXCLIENTCLKOUT, EMACCLIENTRXCLIENTCLKOUT_OUT);
  buf B_EMACCLIENTRXD0 (EMACCLIENTRXD[0], EMACCLIENTRXD_OUT[0]);
  buf B_EMACCLIENTRXD1 (EMACCLIENTRXD[1], EMACCLIENTRXD_OUT[1]);
  buf B_EMACCLIENTRXD10 (EMACCLIENTRXD[10], EMACCLIENTRXD_OUT[10]);
  buf B_EMACCLIENTRXD11 (EMACCLIENTRXD[11], EMACCLIENTRXD_OUT[11]);
  buf B_EMACCLIENTRXD12 (EMACCLIENTRXD[12], EMACCLIENTRXD_OUT[12]);
  buf B_EMACCLIENTRXD13 (EMACCLIENTRXD[13], EMACCLIENTRXD_OUT[13]);
  buf B_EMACCLIENTRXD14 (EMACCLIENTRXD[14], EMACCLIENTRXD_OUT[14]);
  buf B_EMACCLIENTRXD15 (EMACCLIENTRXD[15], EMACCLIENTRXD_OUT[15]);
  buf B_EMACCLIENTRXD2 (EMACCLIENTRXD[2], EMACCLIENTRXD_OUT[2]);
  buf B_EMACCLIENTRXD3 (EMACCLIENTRXD[3], EMACCLIENTRXD_OUT[3]);
  buf B_EMACCLIENTRXD4 (EMACCLIENTRXD[4], EMACCLIENTRXD_OUT[4]);
  buf B_EMACCLIENTRXD5 (EMACCLIENTRXD[5], EMACCLIENTRXD_OUT[5]);
  buf B_EMACCLIENTRXD6 (EMACCLIENTRXD[6], EMACCLIENTRXD_OUT[6]);
  buf B_EMACCLIENTRXD7 (EMACCLIENTRXD[7], EMACCLIENTRXD_OUT[7]);
  buf B_EMACCLIENTRXD8 (EMACCLIENTRXD[8], EMACCLIENTRXD_OUT[8]);
  buf B_EMACCLIENTRXD9 (EMACCLIENTRXD[9], EMACCLIENTRXD_OUT[9]);
  buf B_EMACCLIENTRXDVLD (EMACCLIENTRXDVLD, EMACCLIENTRXDVLD_OUT);
  buf B_EMACCLIENTRXDVLDMSW (EMACCLIENTRXDVLDMSW, EMACCLIENTRXDVLDMSW_OUT);
  buf B_EMACCLIENTRXFRAMEDROP (EMACCLIENTRXFRAMEDROP, EMACCLIENTRXFRAMEDROP_OUT);
  buf B_EMACCLIENTRXGOODFRAME (EMACCLIENTRXGOODFRAME, EMACCLIENTRXGOODFRAME_OUT);
  buf B_EMACCLIENTRXSTATS0 (EMACCLIENTRXSTATS[0], EMACCLIENTRXSTATS_OUT[0]);
  buf B_EMACCLIENTRXSTATS1 (EMACCLIENTRXSTATS[1], EMACCLIENTRXSTATS_OUT[1]);
  buf B_EMACCLIENTRXSTATS2 (EMACCLIENTRXSTATS[2], EMACCLIENTRXSTATS_OUT[2]);
  buf B_EMACCLIENTRXSTATS3 (EMACCLIENTRXSTATS[3], EMACCLIENTRXSTATS_OUT[3]);
  buf B_EMACCLIENTRXSTATS4 (EMACCLIENTRXSTATS[4], EMACCLIENTRXSTATS_OUT[4]);
  buf B_EMACCLIENTRXSTATS5 (EMACCLIENTRXSTATS[5], EMACCLIENTRXSTATS_OUT[5]);
  buf B_EMACCLIENTRXSTATS6 (EMACCLIENTRXSTATS[6], EMACCLIENTRXSTATS_OUT[6]);
  buf B_EMACCLIENTRXSTATSBYTEVLD (EMACCLIENTRXSTATSBYTEVLD, EMACCLIENTRXSTATSBYTEVLD_OUT);
  buf B_EMACCLIENTRXSTATSVLD (EMACCLIENTRXSTATSVLD, EMACCLIENTRXSTATSVLD_OUT);
  buf B_EMACCLIENTTXACK (EMACCLIENTTXACK, EMACCLIENTTXACK_OUT);
  buf B_EMACCLIENTTXCLIENTCLKOUT (EMACCLIENTTXCLIENTCLKOUT, EMACCLIENTTXCLIENTCLKOUT_OUT);
  buf B_EMACCLIENTTXCOLLISION (EMACCLIENTTXCOLLISION, EMACCLIENTTXCOLLISION_OUT);
  buf B_EMACCLIENTTXRETRANSMIT (EMACCLIENTTXRETRANSMIT, EMACCLIENTTXRETRANSMIT_OUT);
  buf B_EMACCLIENTTXSTATS (EMACCLIENTTXSTATS, EMACCLIENTTXSTATS_OUT);
  buf B_EMACCLIENTTXSTATSBYTEVLD (EMACCLIENTTXSTATSBYTEVLD, EMACCLIENTTXSTATSBYTEVLD_OUT);
  buf B_EMACCLIENTTXSTATSVLD (EMACCLIENTTXSTATSVLD, EMACCLIENTTXSTATSVLD_OUT);
  buf B_EMACDCRACK (EMACDCRACK, EMACDCRACK_OUT);
  buf B_EMACDCRDBUS0 (EMACDCRDBUS[0], EMACDCRDBUS_OUT[0]);
  buf B_EMACDCRDBUS1 (EMACDCRDBUS[1], EMACDCRDBUS_OUT[1]);
  buf B_EMACDCRDBUS10 (EMACDCRDBUS[10], EMACDCRDBUS_OUT[10]);
  buf B_EMACDCRDBUS11 (EMACDCRDBUS[11], EMACDCRDBUS_OUT[11]);
  buf B_EMACDCRDBUS12 (EMACDCRDBUS[12], EMACDCRDBUS_OUT[12]);
  buf B_EMACDCRDBUS13 (EMACDCRDBUS[13], EMACDCRDBUS_OUT[13]);
  buf B_EMACDCRDBUS14 (EMACDCRDBUS[14], EMACDCRDBUS_OUT[14]);
  buf B_EMACDCRDBUS15 (EMACDCRDBUS[15], EMACDCRDBUS_OUT[15]);
  buf B_EMACDCRDBUS16 (EMACDCRDBUS[16], EMACDCRDBUS_OUT[16]);
  buf B_EMACDCRDBUS17 (EMACDCRDBUS[17], EMACDCRDBUS_OUT[17]);
  buf B_EMACDCRDBUS18 (EMACDCRDBUS[18], EMACDCRDBUS_OUT[18]);
  buf B_EMACDCRDBUS19 (EMACDCRDBUS[19], EMACDCRDBUS_OUT[19]);
  buf B_EMACDCRDBUS2 (EMACDCRDBUS[2], EMACDCRDBUS_OUT[2]);
  buf B_EMACDCRDBUS20 (EMACDCRDBUS[20], EMACDCRDBUS_OUT[20]);
  buf B_EMACDCRDBUS21 (EMACDCRDBUS[21], EMACDCRDBUS_OUT[21]);
  buf B_EMACDCRDBUS22 (EMACDCRDBUS[22], EMACDCRDBUS_OUT[22]);
  buf B_EMACDCRDBUS23 (EMACDCRDBUS[23], EMACDCRDBUS_OUT[23]);
  buf B_EMACDCRDBUS24 (EMACDCRDBUS[24], EMACDCRDBUS_OUT[24]);
  buf B_EMACDCRDBUS25 (EMACDCRDBUS[25], EMACDCRDBUS_OUT[25]);
  buf B_EMACDCRDBUS26 (EMACDCRDBUS[26], EMACDCRDBUS_OUT[26]);
  buf B_EMACDCRDBUS27 (EMACDCRDBUS[27], EMACDCRDBUS_OUT[27]);
  buf B_EMACDCRDBUS28 (EMACDCRDBUS[28], EMACDCRDBUS_OUT[28]);
  buf B_EMACDCRDBUS29 (EMACDCRDBUS[29], EMACDCRDBUS_OUT[29]);
  buf B_EMACDCRDBUS3 (EMACDCRDBUS[3], EMACDCRDBUS_OUT[3]);
  buf B_EMACDCRDBUS30 (EMACDCRDBUS[30], EMACDCRDBUS_OUT[30]);
  buf B_EMACDCRDBUS31 (EMACDCRDBUS[31], EMACDCRDBUS_OUT[31]);
  buf B_EMACDCRDBUS4 (EMACDCRDBUS[4], EMACDCRDBUS_OUT[4]);
  buf B_EMACDCRDBUS5 (EMACDCRDBUS[5], EMACDCRDBUS_OUT[5]);
  buf B_EMACDCRDBUS6 (EMACDCRDBUS[6], EMACDCRDBUS_OUT[6]);
  buf B_EMACDCRDBUS7 (EMACDCRDBUS[7], EMACDCRDBUS_OUT[7]);
  buf B_EMACDCRDBUS8 (EMACDCRDBUS[8], EMACDCRDBUS_OUT[8]);
  buf B_EMACDCRDBUS9 (EMACDCRDBUS[9], EMACDCRDBUS_OUT[9]);
  buf B_EMACPHYENCOMMAALIGN (EMACPHYENCOMMAALIGN, EMACPHYENCOMMAALIGN_OUT);
  buf B_EMACPHYLOOPBACKMSB (EMACPHYLOOPBACKMSB, EMACPHYLOOPBACKMSB_OUT);
  buf B_EMACPHYMCLKOUT (EMACPHYMCLKOUT, EMACPHYMCLKOUT_OUT);
  buf B_EMACPHYMDOUT (EMACPHYMDOUT, EMACPHYMDOUT_OUT);
  buf B_EMACPHYMDTRI (EMACPHYMDTRI, EMACPHYMDTRI_OUT);
  buf B_EMACPHYMGTRXRESET (EMACPHYMGTRXRESET, EMACPHYMGTRXRESET_OUT);
  buf B_EMACPHYMGTTXRESET (EMACPHYMGTTXRESET, EMACPHYMGTTXRESET_OUT);
  buf B_EMACPHYPOWERDOWN (EMACPHYPOWERDOWN, EMACPHYPOWERDOWN_OUT);
  buf B_EMACPHYSYNCACQSTATUS (EMACPHYSYNCACQSTATUS, EMACPHYSYNCACQSTATUS_OUT);
  buf B_EMACPHYTXCHARDISPMODE (EMACPHYTXCHARDISPMODE, EMACPHYTXCHARDISPMODE_OUT);
  buf B_EMACPHYTXCHARDISPVAL (EMACPHYTXCHARDISPVAL, EMACPHYTXCHARDISPVAL_OUT);
  buf B_EMACPHYTXCHARISK (EMACPHYTXCHARISK, EMACPHYTXCHARISK_OUT);
  buf B_EMACPHYTXCLK (EMACPHYTXCLK, EMACPHYTXCLK_OUT);
  buf B_EMACPHYTXD0 (EMACPHYTXD[0], EMACPHYTXD_OUT[0]);
  buf B_EMACPHYTXD1 (EMACPHYTXD[1], EMACPHYTXD_OUT[1]);
  buf B_EMACPHYTXD2 (EMACPHYTXD[2], EMACPHYTXD_OUT[2]);
  buf B_EMACPHYTXD3 (EMACPHYTXD[3], EMACPHYTXD_OUT[3]);
  buf B_EMACPHYTXD4 (EMACPHYTXD[4], EMACPHYTXD_OUT[4]);
  buf B_EMACPHYTXD5 (EMACPHYTXD[5], EMACPHYTXD_OUT[5]);
  buf B_EMACPHYTXD6 (EMACPHYTXD[6], EMACPHYTXD_OUT[6]);
  buf B_EMACPHYTXD7 (EMACPHYTXD[7], EMACPHYTXD_OUT[7]);
  buf B_EMACPHYTXEN (EMACPHYTXEN, EMACPHYTXEN_OUT);
  buf B_EMACPHYTXER (EMACPHYTXER, EMACPHYTXER_OUT);
  buf B_EMACPHYTXGMIIMIICLKOUT (EMACPHYTXGMIIMIICLKOUT, EMACPHYTXGMIIMIICLKOUT_OUT);
  buf B_EMACSPEEDIS10100 (EMACSPEEDIS10100, EMACSPEEDIS10100_OUT);
  buf B_HOSTMIIMRDY (HOSTMIIMRDY, HOSTMIIMRDY_OUT);
  buf B_HOSTRDDATA0 (HOSTRDDATA[0], HOSTRDDATA_OUT[0]);
  buf B_HOSTRDDATA1 (HOSTRDDATA[1], HOSTRDDATA_OUT[1]);
  buf B_HOSTRDDATA10 (HOSTRDDATA[10], HOSTRDDATA_OUT[10]);
  buf B_HOSTRDDATA11 (HOSTRDDATA[11], HOSTRDDATA_OUT[11]);
  buf B_HOSTRDDATA12 (HOSTRDDATA[12], HOSTRDDATA_OUT[12]);
  buf B_HOSTRDDATA13 (HOSTRDDATA[13], HOSTRDDATA_OUT[13]);
  buf B_HOSTRDDATA14 (HOSTRDDATA[14], HOSTRDDATA_OUT[14]);
  buf B_HOSTRDDATA15 (HOSTRDDATA[15], HOSTRDDATA_OUT[15]);
  buf B_HOSTRDDATA16 (HOSTRDDATA[16], HOSTRDDATA_OUT[16]);
  buf B_HOSTRDDATA17 (HOSTRDDATA[17], HOSTRDDATA_OUT[17]);
  buf B_HOSTRDDATA18 (HOSTRDDATA[18], HOSTRDDATA_OUT[18]);
  buf B_HOSTRDDATA19 (HOSTRDDATA[19], HOSTRDDATA_OUT[19]);
  buf B_HOSTRDDATA2 (HOSTRDDATA[2], HOSTRDDATA_OUT[2]);
  buf B_HOSTRDDATA20 (HOSTRDDATA[20], HOSTRDDATA_OUT[20]);
  buf B_HOSTRDDATA21 (HOSTRDDATA[21], HOSTRDDATA_OUT[21]);
  buf B_HOSTRDDATA22 (HOSTRDDATA[22], HOSTRDDATA_OUT[22]);
  buf B_HOSTRDDATA23 (HOSTRDDATA[23], HOSTRDDATA_OUT[23]);
  buf B_HOSTRDDATA24 (HOSTRDDATA[24], HOSTRDDATA_OUT[24]);
  buf B_HOSTRDDATA25 (HOSTRDDATA[25], HOSTRDDATA_OUT[25]);
  buf B_HOSTRDDATA26 (HOSTRDDATA[26], HOSTRDDATA_OUT[26]);
  buf B_HOSTRDDATA27 (HOSTRDDATA[27], HOSTRDDATA_OUT[27]);
  buf B_HOSTRDDATA28 (HOSTRDDATA[28], HOSTRDDATA_OUT[28]);
  buf B_HOSTRDDATA29 (HOSTRDDATA[29], HOSTRDDATA_OUT[29]);
  buf B_HOSTRDDATA3 (HOSTRDDATA[3], HOSTRDDATA_OUT[3]);
  buf B_HOSTRDDATA30 (HOSTRDDATA[30], HOSTRDDATA_OUT[30]);
  buf B_HOSTRDDATA31 (HOSTRDDATA[31], HOSTRDDATA_OUT[31]);
  buf B_HOSTRDDATA4 (HOSTRDDATA[4], HOSTRDDATA_OUT[4]);
  buf B_HOSTRDDATA5 (HOSTRDDATA[5], HOSTRDDATA_OUT[5]);
  buf B_HOSTRDDATA6 (HOSTRDDATA[6], HOSTRDDATA_OUT[6]);
  buf B_HOSTRDDATA7 (HOSTRDDATA[7], HOSTRDDATA_OUT[7]);
  buf B_HOSTRDDATA8 (HOSTRDDATA[8], HOSTRDDATA_OUT[8]);
  buf B_HOSTRDDATA9 (HOSTRDDATA[9], HOSTRDDATA_OUT[9]);

  buf B_CLIENTEMACDCMLOCKED (CLIENTEMACDCMLOCKED_IN, CLIENTEMACDCMLOCKED);
  buf B_CLIENTEMACPAUSEREQ (CLIENTEMACPAUSEREQ_IN, CLIENTEMACPAUSEREQ);
  buf B_CLIENTEMACPAUSEVAL0 (CLIENTEMACPAUSEVAL_IN[0], CLIENTEMACPAUSEVAL[0]);
  buf B_CLIENTEMACPAUSEVAL1 (CLIENTEMACPAUSEVAL_IN[1], CLIENTEMACPAUSEVAL[1]);
  buf B_CLIENTEMACPAUSEVAL10 (CLIENTEMACPAUSEVAL_IN[10], CLIENTEMACPAUSEVAL[10]);
  buf B_CLIENTEMACPAUSEVAL11 (CLIENTEMACPAUSEVAL_IN[11], CLIENTEMACPAUSEVAL[11]);
  buf B_CLIENTEMACPAUSEVAL12 (CLIENTEMACPAUSEVAL_IN[12], CLIENTEMACPAUSEVAL[12]);
  buf B_CLIENTEMACPAUSEVAL13 (CLIENTEMACPAUSEVAL_IN[13], CLIENTEMACPAUSEVAL[13]);
  buf B_CLIENTEMACPAUSEVAL14 (CLIENTEMACPAUSEVAL_IN[14], CLIENTEMACPAUSEVAL[14]);
  buf B_CLIENTEMACPAUSEVAL15 (CLIENTEMACPAUSEVAL_IN[15], CLIENTEMACPAUSEVAL[15]);
  buf B_CLIENTEMACPAUSEVAL2 (CLIENTEMACPAUSEVAL_IN[2], CLIENTEMACPAUSEVAL[2]);
  buf B_CLIENTEMACPAUSEVAL3 (CLIENTEMACPAUSEVAL_IN[3], CLIENTEMACPAUSEVAL[3]);
  buf B_CLIENTEMACPAUSEVAL4 (CLIENTEMACPAUSEVAL_IN[4], CLIENTEMACPAUSEVAL[4]);
  buf B_CLIENTEMACPAUSEVAL5 (CLIENTEMACPAUSEVAL_IN[5], CLIENTEMACPAUSEVAL[5]);
  buf B_CLIENTEMACPAUSEVAL6 (CLIENTEMACPAUSEVAL_IN[6], CLIENTEMACPAUSEVAL[6]);
  buf B_CLIENTEMACPAUSEVAL7 (CLIENTEMACPAUSEVAL_IN[7], CLIENTEMACPAUSEVAL[7]);
  buf B_CLIENTEMACPAUSEVAL8 (CLIENTEMACPAUSEVAL_IN[8], CLIENTEMACPAUSEVAL[8]);
  buf B_CLIENTEMACPAUSEVAL9 (CLIENTEMACPAUSEVAL_IN[9], CLIENTEMACPAUSEVAL[9]);
  buf B_CLIENTEMACRXCLIENTCLKIN (CLIENTEMACRXCLIENTCLKIN_IN, CLIENTEMACRXCLIENTCLKIN);
  buf B_CLIENTEMACTXCLIENTCLKIN (CLIENTEMACTXCLIENTCLKIN_IN, CLIENTEMACTXCLIENTCLKIN);
  buf B_CLIENTEMACTXD0 (CLIENTEMACTXD_IN[0], CLIENTEMACTXD[0]);
  buf B_CLIENTEMACTXD1 (CLIENTEMACTXD_IN[1], CLIENTEMACTXD[1]);
  buf B_CLIENTEMACTXD10 (CLIENTEMACTXD_IN[10], CLIENTEMACTXD[10]);
  buf B_CLIENTEMACTXD11 (CLIENTEMACTXD_IN[11], CLIENTEMACTXD[11]);
  buf B_CLIENTEMACTXD12 (CLIENTEMACTXD_IN[12], CLIENTEMACTXD[12]);
  buf B_CLIENTEMACTXD13 (CLIENTEMACTXD_IN[13], CLIENTEMACTXD[13]);
  buf B_CLIENTEMACTXD14 (CLIENTEMACTXD_IN[14], CLIENTEMACTXD[14]);
  buf B_CLIENTEMACTXD15 (CLIENTEMACTXD_IN[15], CLIENTEMACTXD[15]);
  buf B_CLIENTEMACTXD2 (CLIENTEMACTXD_IN[2], CLIENTEMACTXD[2]);
  buf B_CLIENTEMACTXD3 (CLIENTEMACTXD_IN[3], CLIENTEMACTXD[3]);
  buf B_CLIENTEMACTXD4 (CLIENTEMACTXD_IN[4], CLIENTEMACTXD[4]);
  buf B_CLIENTEMACTXD5 (CLIENTEMACTXD_IN[5], CLIENTEMACTXD[5]);
  buf B_CLIENTEMACTXD6 (CLIENTEMACTXD_IN[6], CLIENTEMACTXD[6]);
  buf B_CLIENTEMACTXD7 (CLIENTEMACTXD_IN[7], CLIENTEMACTXD[7]);
  buf B_CLIENTEMACTXD8 (CLIENTEMACTXD_IN[8], CLIENTEMACTXD[8]);
  buf B_CLIENTEMACTXD9 (CLIENTEMACTXD_IN[9], CLIENTEMACTXD[9]);
  buf B_CLIENTEMACTXDVLD (CLIENTEMACTXDVLD_IN, CLIENTEMACTXDVLD);
  buf B_CLIENTEMACTXDVLDMSW (CLIENTEMACTXDVLDMSW_IN, CLIENTEMACTXDVLDMSW);
  buf B_CLIENTEMACTXFIRSTBYTE (CLIENTEMACTXFIRSTBYTE_IN, CLIENTEMACTXFIRSTBYTE);
  buf B_CLIENTEMACTXIFGDELAY0 (CLIENTEMACTXIFGDELAY_IN[0], CLIENTEMACTXIFGDELAY[0]);
  buf B_CLIENTEMACTXIFGDELAY1 (CLIENTEMACTXIFGDELAY_IN[1], CLIENTEMACTXIFGDELAY[1]);
  buf B_CLIENTEMACTXIFGDELAY2 (CLIENTEMACTXIFGDELAY_IN[2], CLIENTEMACTXIFGDELAY[2]);
  buf B_CLIENTEMACTXIFGDELAY3 (CLIENTEMACTXIFGDELAY_IN[3], CLIENTEMACTXIFGDELAY[3]);
  buf B_CLIENTEMACTXIFGDELAY4 (CLIENTEMACTXIFGDELAY_IN[4], CLIENTEMACTXIFGDELAY[4]);
  buf B_CLIENTEMACTXIFGDELAY5 (CLIENTEMACTXIFGDELAY_IN[5], CLIENTEMACTXIFGDELAY[5]);
  buf B_CLIENTEMACTXIFGDELAY6 (CLIENTEMACTXIFGDELAY_IN[6], CLIENTEMACTXIFGDELAY[6]);
  buf B_CLIENTEMACTXIFGDELAY7 (CLIENTEMACTXIFGDELAY_IN[7], CLIENTEMACTXIFGDELAY[7]);
  buf B_CLIENTEMACTXUNDERRUN (CLIENTEMACTXUNDERRUN_IN, CLIENTEMACTXUNDERRUN);
  buf B_DCREMACABUS0 (DCREMACABUS_IN[0], DCREMACABUS[0]);
  buf B_DCREMACABUS1 (DCREMACABUS_IN[1], DCREMACABUS[1]);
  buf B_DCREMACABUS2 (DCREMACABUS_IN[2], DCREMACABUS[2]);
  buf B_DCREMACABUS3 (DCREMACABUS_IN[3], DCREMACABUS[3]);
  buf B_DCREMACABUS4 (DCREMACABUS_IN[4], DCREMACABUS[4]);
  buf B_DCREMACABUS5 (DCREMACABUS_IN[5], DCREMACABUS[5]);
  buf B_DCREMACABUS6 (DCREMACABUS_IN[6], DCREMACABUS[6]);
  buf B_DCREMACABUS7 (DCREMACABUS_IN[7], DCREMACABUS[7]);
  buf B_DCREMACABUS8 (DCREMACABUS_IN[8], DCREMACABUS[8]);
  buf B_DCREMACABUS9 (DCREMACABUS_IN[9], DCREMACABUS[9]);
  buf B_DCREMACCLK (DCREMACCLK_IN, DCREMACCLK);
  buf B_DCREMACDBUS0 (DCREMACDBUS_IN[0], DCREMACDBUS[0]);
  buf B_DCREMACDBUS1 (DCREMACDBUS_IN[1], DCREMACDBUS[1]);
  buf B_DCREMACDBUS10 (DCREMACDBUS_IN[10], DCREMACDBUS[10]);
  buf B_DCREMACDBUS11 (DCREMACDBUS_IN[11], DCREMACDBUS[11]);
  buf B_DCREMACDBUS12 (DCREMACDBUS_IN[12], DCREMACDBUS[12]);
  buf B_DCREMACDBUS13 (DCREMACDBUS_IN[13], DCREMACDBUS[13]);
  buf B_DCREMACDBUS14 (DCREMACDBUS_IN[14], DCREMACDBUS[14]);
  buf B_DCREMACDBUS15 (DCREMACDBUS_IN[15], DCREMACDBUS[15]);
  buf B_DCREMACDBUS16 (DCREMACDBUS_IN[16], DCREMACDBUS[16]);
  buf B_DCREMACDBUS17 (DCREMACDBUS_IN[17], DCREMACDBUS[17]);
  buf B_DCREMACDBUS18 (DCREMACDBUS_IN[18], DCREMACDBUS[18]);
  buf B_DCREMACDBUS19 (DCREMACDBUS_IN[19], DCREMACDBUS[19]);
  buf B_DCREMACDBUS2 (DCREMACDBUS_IN[2], DCREMACDBUS[2]);
  buf B_DCREMACDBUS20 (DCREMACDBUS_IN[20], DCREMACDBUS[20]);
  buf B_DCREMACDBUS21 (DCREMACDBUS_IN[21], DCREMACDBUS[21]);
  buf B_DCREMACDBUS22 (DCREMACDBUS_IN[22], DCREMACDBUS[22]);
  buf B_DCREMACDBUS23 (DCREMACDBUS_IN[23], DCREMACDBUS[23]);
  buf B_DCREMACDBUS24 (DCREMACDBUS_IN[24], DCREMACDBUS[24]);
  buf B_DCREMACDBUS25 (DCREMACDBUS_IN[25], DCREMACDBUS[25]);
  buf B_DCREMACDBUS26 (DCREMACDBUS_IN[26], DCREMACDBUS[26]);
  buf B_DCREMACDBUS27 (DCREMACDBUS_IN[27], DCREMACDBUS[27]);
  buf B_DCREMACDBUS28 (DCREMACDBUS_IN[28], DCREMACDBUS[28]);
  buf B_DCREMACDBUS29 (DCREMACDBUS_IN[29], DCREMACDBUS[29]);
  buf B_DCREMACDBUS3 (DCREMACDBUS_IN[3], DCREMACDBUS[3]);
  buf B_DCREMACDBUS30 (DCREMACDBUS_IN[30], DCREMACDBUS[30]);
  buf B_DCREMACDBUS31 (DCREMACDBUS_IN[31], DCREMACDBUS[31]);
  buf B_DCREMACDBUS4 (DCREMACDBUS_IN[4], DCREMACDBUS[4]);
  buf B_DCREMACDBUS5 (DCREMACDBUS_IN[5], DCREMACDBUS[5]);
  buf B_DCREMACDBUS6 (DCREMACDBUS_IN[6], DCREMACDBUS[6]);
  buf B_DCREMACDBUS7 (DCREMACDBUS_IN[7], DCREMACDBUS[7]);
  buf B_DCREMACDBUS8 (DCREMACDBUS_IN[8], DCREMACDBUS[8]);
  buf B_DCREMACDBUS9 (DCREMACDBUS_IN[9], DCREMACDBUS[9]);
  buf B_DCREMACENABLE (DCREMACENABLE_IN, DCREMACENABLE);
  buf B_DCREMACREAD (DCREMACREAD_IN, DCREMACREAD);
  buf B_DCREMACWRITE (DCREMACWRITE_IN, DCREMACWRITE);
  buf B_HOSTADDR0 (HOSTADDR_IN[0], HOSTADDR[0]);
  buf B_HOSTADDR1 (HOSTADDR_IN[1], HOSTADDR[1]);
  buf B_HOSTADDR2 (HOSTADDR_IN[2], HOSTADDR[2]);
  buf B_HOSTADDR3 (HOSTADDR_IN[3], HOSTADDR[3]);
  buf B_HOSTADDR4 (HOSTADDR_IN[4], HOSTADDR[4]);
  buf B_HOSTADDR5 (HOSTADDR_IN[5], HOSTADDR[5]);
  buf B_HOSTADDR6 (HOSTADDR_IN[6], HOSTADDR[6]);
  buf B_HOSTADDR7 (HOSTADDR_IN[7], HOSTADDR[7]);
  buf B_HOSTADDR8 (HOSTADDR_IN[8], HOSTADDR[8]);
  buf B_HOSTADDR9 (HOSTADDR_IN[9], HOSTADDR[9]);
  buf B_HOSTCLK (HOSTCLK_IN, HOSTCLK);
  buf B_HOSTMIIMSEL (HOSTMIIMSEL_IN, HOSTMIIMSEL);
  buf B_HOSTOPCODE0 (HOSTOPCODE_IN[0], HOSTOPCODE[0]);
  buf B_HOSTOPCODE1 (HOSTOPCODE_IN[1], HOSTOPCODE[1]);
  buf B_HOSTREQ (HOSTREQ_IN, HOSTREQ);
  buf B_HOSTWRDATA0 (HOSTWRDATA_IN[0], HOSTWRDATA[0]);
  buf B_HOSTWRDATA1 (HOSTWRDATA_IN[1], HOSTWRDATA[1]);
  buf B_HOSTWRDATA10 (HOSTWRDATA_IN[10], HOSTWRDATA[10]);
  buf B_HOSTWRDATA11 (HOSTWRDATA_IN[11], HOSTWRDATA[11]);
  buf B_HOSTWRDATA12 (HOSTWRDATA_IN[12], HOSTWRDATA[12]);
  buf B_HOSTWRDATA13 (HOSTWRDATA_IN[13], HOSTWRDATA[13]);
  buf B_HOSTWRDATA14 (HOSTWRDATA_IN[14], HOSTWRDATA[14]);
  buf B_HOSTWRDATA15 (HOSTWRDATA_IN[15], HOSTWRDATA[15]);
  buf B_HOSTWRDATA16 (HOSTWRDATA_IN[16], HOSTWRDATA[16]);
  buf B_HOSTWRDATA17 (HOSTWRDATA_IN[17], HOSTWRDATA[17]);
  buf B_HOSTWRDATA18 (HOSTWRDATA_IN[18], HOSTWRDATA[18]);
  buf B_HOSTWRDATA19 (HOSTWRDATA_IN[19], HOSTWRDATA[19]);
  buf B_HOSTWRDATA2 (HOSTWRDATA_IN[2], HOSTWRDATA[2]);
  buf B_HOSTWRDATA20 (HOSTWRDATA_IN[20], HOSTWRDATA[20]);
  buf B_HOSTWRDATA21 (HOSTWRDATA_IN[21], HOSTWRDATA[21]);
  buf B_HOSTWRDATA22 (HOSTWRDATA_IN[22], HOSTWRDATA[22]);
  buf B_HOSTWRDATA23 (HOSTWRDATA_IN[23], HOSTWRDATA[23]);
  buf B_HOSTWRDATA24 (HOSTWRDATA_IN[24], HOSTWRDATA[24]);
  buf B_HOSTWRDATA25 (HOSTWRDATA_IN[25], HOSTWRDATA[25]);
  buf B_HOSTWRDATA26 (HOSTWRDATA_IN[26], HOSTWRDATA[26]);
  buf B_HOSTWRDATA27 (HOSTWRDATA_IN[27], HOSTWRDATA[27]);
  buf B_HOSTWRDATA28 (HOSTWRDATA_IN[28], HOSTWRDATA[28]);
  buf B_HOSTWRDATA29 (HOSTWRDATA_IN[29], HOSTWRDATA[29]);
  buf B_HOSTWRDATA3 (HOSTWRDATA_IN[3], HOSTWRDATA[3]);
  buf B_HOSTWRDATA30 (HOSTWRDATA_IN[30], HOSTWRDATA[30]);
  buf B_HOSTWRDATA31 (HOSTWRDATA_IN[31], HOSTWRDATA[31]);
  buf B_HOSTWRDATA4 (HOSTWRDATA_IN[4], HOSTWRDATA[4]);
  buf B_HOSTWRDATA5 (HOSTWRDATA_IN[5], HOSTWRDATA[5]);
  buf B_HOSTWRDATA6 (HOSTWRDATA_IN[6], HOSTWRDATA[6]);
  buf B_HOSTWRDATA7 (HOSTWRDATA_IN[7], HOSTWRDATA[7]);
  buf B_HOSTWRDATA8 (HOSTWRDATA_IN[8], HOSTWRDATA[8]);
  buf B_HOSTWRDATA9 (HOSTWRDATA_IN[9], HOSTWRDATA[9]);
  buf B_PHYEMACCOL (PHYEMACCOL_IN, PHYEMACCOL);
  buf B_PHYEMACCRS (PHYEMACCRS_IN, PHYEMACCRS);
  buf B_PHYEMACGTXCLK (PHYEMACGTXCLK_IN, PHYEMACGTXCLK);
  buf B_PHYEMACMCLKIN (PHYEMACMCLKIN_IN, PHYEMACMCLKIN);
  buf B_PHYEMACMDIN (PHYEMACMDIN_IN, PHYEMACMDIN);
  buf B_PHYEMACMIITXCLK (PHYEMACMIITXCLK_IN, PHYEMACMIITXCLK);
  buf B_PHYEMACPHYAD0 (PHYEMACPHYAD_IN[0], PHYEMACPHYAD[0]);
  buf B_PHYEMACPHYAD1 (PHYEMACPHYAD_IN[1], PHYEMACPHYAD[1]);
  buf B_PHYEMACPHYAD2 (PHYEMACPHYAD_IN[2], PHYEMACPHYAD[2]);
  buf B_PHYEMACPHYAD3 (PHYEMACPHYAD_IN[3], PHYEMACPHYAD[3]);
  buf B_PHYEMACPHYAD4 (PHYEMACPHYAD_IN[4], PHYEMACPHYAD[4]);
  buf B_PHYEMACRXBUFSTATUS0 (PHYEMACRXBUFSTATUS_IN[0], PHYEMACRXBUFSTATUS[0]);
  buf B_PHYEMACRXBUFSTATUS1 (PHYEMACRXBUFSTATUS_IN[1], PHYEMACRXBUFSTATUS[1]);
  buf B_PHYEMACRXCHARISCOMMA (PHYEMACRXCHARISCOMMA_IN, PHYEMACRXCHARISCOMMA);
  buf B_PHYEMACRXCHARISK (PHYEMACRXCHARISK_IN, PHYEMACRXCHARISK);
  buf B_PHYEMACRXCLK (PHYEMACRXCLK_IN, PHYEMACRXCLK);
  buf B_PHYEMACRXCLKCORCNT0 (PHYEMACRXCLKCORCNT_IN[0], PHYEMACRXCLKCORCNT[0]);
  buf B_PHYEMACRXCLKCORCNT1 (PHYEMACRXCLKCORCNT_IN[1], PHYEMACRXCLKCORCNT[1]);
  buf B_PHYEMACRXCLKCORCNT2 (PHYEMACRXCLKCORCNT_IN[2], PHYEMACRXCLKCORCNT[2]);
  buf B_PHYEMACRXD0 (PHYEMACRXD_IN[0], PHYEMACRXD[0]);
  buf B_PHYEMACRXD1 (PHYEMACRXD_IN[1], PHYEMACRXD[1]);
  buf B_PHYEMACRXD2 (PHYEMACRXD_IN[2], PHYEMACRXD[2]);
  buf B_PHYEMACRXD3 (PHYEMACRXD_IN[3], PHYEMACRXD[3]);
  buf B_PHYEMACRXD4 (PHYEMACRXD_IN[4], PHYEMACRXD[4]);
  buf B_PHYEMACRXD5 (PHYEMACRXD_IN[5], PHYEMACRXD[5]);
  buf B_PHYEMACRXD6 (PHYEMACRXD_IN[6], PHYEMACRXD[6]);
  buf B_PHYEMACRXD7 (PHYEMACRXD_IN[7], PHYEMACRXD[7]);
  buf B_PHYEMACRXDISPERR (PHYEMACRXDISPERR_IN, PHYEMACRXDISPERR);
  buf B_PHYEMACRXDV (PHYEMACRXDV_IN, PHYEMACRXDV);
  buf B_PHYEMACRXER (PHYEMACRXER_IN, PHYEMACRXER);
  buf B_PHYEMACRXNOTINTABLE (PHYEMACRXNOTINTABLE_IN, PHYEMACRXNOTINTABLE);
  buf B_PHYEMACRXRUNDISP (PHYEMACRXRUNDISP_IN, PHYEMACRXRUNDISP);
  buf B_PHYEMACSIGNALDET (PHYEMACSIGNALDET_IN, PHYEMACSIGNALDET);
  buf B_PHYEMACTXBUFERR (PHYEMACTXBUFERR_IN, PHYEMACTXBUFERR);
  buf B_PHYEMACTXGMIIMIICLKIN (PHYEMACTXGMIIMIICLKIN_IN, PHYEMACTXGMIIMIICLKIN);
  buf B_RESET (RESET_IN, RESET);

  wire [0:31] delay_EMACDCRDBUS;
  wire [15:0] delay_EMACCLIENTRXD;
  wire [31:0] delay_HOSTRDDATA;
  wire [6:0] delay_EMACCLIENTRXSTATS;
  wire [7:0] delay_EMACPHYTXD;
  wire delay_DCRHOSTDONEIR;
  wire delay_EMACCLIENTANINTERRUPT;
  wire delay_EMACCLIENTRXBADFRAME;
  wire delay_EMACCLIENTRXCLIENTCLKOUT;
  wire delay_EMACCLIENTRXDVLD;
  wire delay_EMACCLIENTRXDVLDMSW;
  wire delay_EMACCLIENTRXFRAMEDROP;
  wire delay_EMACCLIENTRXGOODFRAME;
  wire delay_EMACCLIENTRXSTATSBYTEVLD;
  wire delay_EMACCLIENTRXSTATSVLD;
  wire delay_EMACCLIENTTXACK;
  wire delay_EMACCLIENTTXCLIENTCLKOUT;
  wire delay_EMACCLIENTTXCOLLISION;
  wire delay_EMACCLIENTTXRETRANSMIT;
  wire delay_EMACCLIENTTXSTATS;
  wire delay_EMACCLIENTTXSTATSBYTEVLD;
  wire delay_EMACCLIENTTXSTATSVLD;
  wire delay_EMACDCRACK;
  wire delay_EMACPHYENCOMMAALIGN;
  wire delay_EMACPHYLOOPBACKMSB;
  wire delay_EMACPHYMCLKOUT;
  wire delay_EMACPHYMDOUT;
  wire delay_EMACPHYMDTRI;
  wire delay_EMACPHYMGTRXRESET;
  wire delay_EMACPHYMGTTXRESET;
  wire delay_EMACPHYPOWERDOWN;
  wire delay_EMACPHYSYNCACQSTATUS;
  wire delay_EMACPHYTXCHARDISPMODE;
  wire delay_EMACPHYTXCHARDISPVAL;
  wire delay_EMACPHYTXCHARISK;
  wire delay_EMACPHYTXCLK;
  wire delay_EMACPHYTXEN;
  wire delay_EMACPHYTXER;
  wire delay_EMACPHYTXGMIIMIICLKOUT;
  wire delay_EMACSPEEDIS10100;
  wire delay_HOSTMIIMRDY;

  wire [0:31] delay_DCREMACDBUS;
  wire [0:9] delay_DCREMACABUS;
  wire [15:0] delay_CLIENTEMACPAUSEVAL;
  wire [15:0] delay_CLIENTEMACTXD;
  wire [1:0] delay_HOSTOPCODE;
  wire [1:0] delay_PHYEMACRXBUFSTATUS;
  wire [2:0] delay_PHYEMACRXCLKCORCNT;
  wire [31:0] delay_HOSTWRDATA;
  wire [4:0] delay_PHYEMACPHYAD;
  wire [7:0] delay_CLIENTEMACTXIFGDELAY;
  wire [7:0] delay_PHYEMACRXD;
  wire [9:0] delay_HOSTADDR;
  wire delay_CLIENTEMACDCMLOCKED;
  wire delay_CLIENTEMACPAUSEREQ;
  wire delay_CLIENTEMACRXCLIENTCLKIN;
  wire delay_CLIENTEMACTXCLIENTCLKIN;
  wire delay_CLIENTEMACTXDVLD;
  wire delay_CLIENTEMACTXDVLDMSW;
  wire delay_CLIENTEMACTXFIRSTBYTE;
  wire delay_CLIENTEMACTXUNDERRUN;
  wire delay_DCREMACCLK;
  wire delay_DCREMACENABLE;
  wire delay_DCREMACREAD;
  wire delay_DCREMACWRITE;
  wire delay_HOSTCLK;
  wire delay_HOSTMIIMSEL;
  wire delay_HOSTREQ;
  wire delay_PHYEMACCOL;
  wire delay_PHYEMACCRS;
  wire delay_PHYEMACGTXCLK;
  wire delay_PHYEMACMCLKIN;
  wire delay_PHYEMACMDIN;
  wire delay_PHYEMACMIITXCLK;
  wire delay_PHYEMACRXCHARISCOMMA;
  wire delay_PHYEMACRXCHARISK;
  wire delay_PHYEMACRXCLK;
  wire delay_PHYEMACRXDISPERR;
  wire delay_PHYEMACRXDV;
  wire delay_PHYEMACRXER;
  wire delay_PHYEMACRXNOTINTABLE;
  wire delay_PHYEMACRXRUNDISP;
  wire delay_PHYEMACSIGNALDET;
  wire delay_PHYEMACTXBUFERR;
  wire delay_PHYEMACTXGMIIMIICLKIN;
  wire delay_RESET;

  assign #(out_delay) DCRHOSTDONEIR_OUT = delay_DCRHOSTDONEIR;
  assign #(out_delay) EMACCLIENTANINTERRUPT_OUT = delay_EMACCLIENTANINTERRUPT;
  assign #(out_delay) EMACCLIENTRXBADFRAME_OUT = delay_EMACCLIENTRXBADFRAME;
  assign #(out_delay) EMACCLIENTRXCLIENTCLKOUT_OUT = delay_EMACCLIENTRXCLIENTCLKOUT;
  assign #(out_delay) EMACCLIENTRXDVLDMSW_OUT = delay_EMACCLIENTRXDVLDMSW;
  assign #(out_delay) EMACCLIENTRXDVLD_OUT = delay_EMACCLIENTRXDVLD;
  assign #(out_delay) EMACCLIENTRXD_OUT = delay_EMACCLIENTRXD;
  assign #(out_delay) EMACCLIENTRXFRAMEDROP_OUT = delay_EMACCLIENTRXFRAMEDROP;
  assign #(out_delay) EMACCLIENTRXGOODFRAME_OUT = delay_EMACCLIENTRXGOODFRAME;
  assign #(out_delay) EMACCLIENTRXSTATSBYTEVLD_OUT = delay_EMACCLIENTRXSTATSBYTEVLD;
  assign #(out_delay) EMACCLIENTRXSTATSVLD_OUT = delay_EMACCLIENTRXSTATSVLD;
  assign #(out_delay) EMACCLIENTRXSTATS_OUT = delay_EMACCLIENTRXSTATS;
  assign #(out_delay) EMACCLIENTTXACK_OUT = delay_EMACCLIENTTXACK;
  assign #(out_delay) EMACCLIENTTXCLIENTCLKOUT_OUT = delay_EMACCLIENTTXCLIENTCLKOUT;
  assign #(out_delay) EMACCLIENTTXCOLLISION_OUT = delay_EMACCLIENTTXCOLLISION;
  assign #(out_delay) EMACCLIENTTXRETRANSMIT_OUT = delay_EMACCLIENTTXRETRANSMIT;
  assign #(out_delay) EMACCLIENTTXSTATSBYTEVLD_OUT = delay_EMACCLIENTTXSTATSBYTEVLD;
  assign #(out_delay) EMACCLIENTTXSTATSVLD_OUT = delay_EMACCLIENTTXSTATSVLD;
  assign #(out_delay) EMACCLIENTTXSTATS_OUT = delay_EMACCLIENTTXSTATS;
  assign #(out_delay) EMACDCRACK_OUT = delay_EMACDCRACK;
  assign #(out_delay) EMACDCRDBUS_OUT = delay_EMACDCRDBUS;
  assign #(out_delay) EMACPHYENCOMMAALIGN_OUT = delay_EMACPHYENCOMMAALIGN;
  assign #(out_delay) EMACPHYLOOPBACKMSB_OUT = delay_EMACPHYLOOPBACKMSB;
  assign #(out_delay) EMACPHYMCLKOUT_OUT = delay_EMACPHYMCLKOUT;
  assign #(out_delay) EMACPHYMDOUT_OUT = delay_EMACPHYMDOUT;
  assign #(out_delay) EMACPHYMDTRI_OUT = delay_EMACPHYMDTRI;
  assign #(out_delay) EMACPHYMGTRXRESET_OUT = delay_EMACPHYMGTRXRESET;
  assign #(out_delay) EMACPHYMGTTXRESET_OUT = delay_EMACPHYMGTTXRESET;
  assign #(out_delay) EMACPHYPOWERDOWN_OUT = delay_EMACPHYPOWERDOWN;
  assign #(out_delay) EMACPHYSYNCACQSTATUS_OUT = delay_EMACPHYSYNCACQSTATUS;
  assign #(out_delay) EMACPHYTXCHARDISPMODE_OUT = delay_EMACPHYTXCHARDISPMODE;
  assign #(out_delay) EMACPHYTXCHARDISPVAL_OUT = delay_EMACPHYTXCHARDISPVAL;
  assign #(out_delay) EMACPHYTXCHARISK_OUT = delay_EMACPHYTXCHARISK;
  assign #(out_delay) EMACPHYTXCLK_OUT = delay_EMACPHYTXCLK;
  assign #(out_delay) EMACPHYTXD_OUT = delay_EMACPHYTXD;
  assign #(out_delay) EMACPHYTXEN_OUT = delay_EMACPHYTXEN;
  assign #(out_delay) EMACPHYTXER_OUT = delay_EMACPHYTXER;
  assign #(out_delay) EMACPHYTXGMIIMIICLKOUT_OUT = delay_EMACPHYTXGMIIMIICLKOUT;
  assign #(out_delay) EMACSPEEDIS10100_OUT = delay_EMACSPEEDIS10100;
  assign #(out_delay) HOSTMIIMRDY_OUT = delay_HOSTMIIMRDY;
  assign #(out_delay) HOSTRDDATA_OUT = delay_HOSTRDDATA;

  assign #(INCLK_DELAY) CLIENTEMACRXCLIENTCLKIN_INDELAY = CLIENTEMACRXCLIENTCLKIN_IN;
  assign #(INCLK_DELAY) CLIENTEMACTXCLIENTCLKIN_INDELAY = CLIENTEMACTXCLIENTCLKIN_IN;
  assign #(INCLK_DELAY) DCREMACCLK_INDELAY = DCREMACCLK_IN;
  assign #(INCLK_DELAY) HOSTCLK_INDELAY = HOSTCLK_IN;
  assign #(INCLK_DELAY) PHYEMACGTXCLK_INDELAY = PHYEMACGTXCLK_IN;
  assign #(INCLK_DELAY) PHYEMACMCLKIN_INDELAY = PHYEMACMCLKIN_IN;
//  assign #(EMACMIITXCLK_DELAY) PHYEMACMIITXCLK_INDELAY = PHYEMACMIITXCLK_IN;
  assign #(EMACMIITXCLK_DELAY) PHYEMACMIITXCLK_ADDED = delay_PHYEMACMIITXCLK;
  assign #(INCLK_DELAY) PHYEMACRXCLK_INDELAY = PHYEMACRXCLK_IN;
  assign #(INCLK_DELAY) PHYEMACTXGMIIMIICLKIN_INDELAY = PHYEMACTXGMIIMIICLKIN_IN;
    
  assign #(in_delay) CLIENTEMACDCMLOCKED_INDELAY = CLIENTEMACDCMLOCKED_IN;
  assign #(in_delay) CLIENTEMACPAUSEREQ_INDELAY = CLIENTEMACPAUSEREQ_IN;
  assign #(in_delay) CLIENTEMACPAUSEVAL_INDELAY = CLIENTEMACPAUSEVAL_IN;
  assign #(in_delay) CLIENTEMACTXDVLDMSW_INDELAY = CLIENTEMACTXDVLDMSW_IN;
  assign #(in_delay) CLIENTEMACTXDVLD_INDELAY = CLIENTEMACTXDVLD_IN;
  assign #(in_delay) CLIENTEMACTXD_INDELAY = CLIENTEMACTXD_IN;
  assign #(in_delay) CLIENTEMACTXFIRSTBYTE_INDELAY = CLIENTEMACTXFIRSTBYTE_IN;
  assign #(in_delay) CLIENTEMACTXIFGDELAY_INDELAY = CLIENTEMACTXIFGDELAY_IN;
  assign #(in_delay) CLIENTEMACTXUNDERRUN_INDELAY = CLIENTEMACTXUNDERRUN_IN;
  assign #(in_delay) DCREMACABUS_INDELAY = DCREMACABUS_IN;
  assign #(in_delay) DCREMACDBUS_INDELAY = DCREMACDBUS_IN;
  assign #(in_delay) DCREMACENABLE_INDELAY = DCREMACENABLE_IN;
  assign #(in_delay) DCREMACREAD_INDELAY = DCREMACREAD_IN;
  assign #(in_delay) DCREMACWRITE_INDELAY = DCREMACWRITE_IN;
  assign #(in_delay) HOSTADDR_INDELAY = HOSTADDR_IN;
  assign #(in_delay) HOSTMIIMSEL_INDELAY = HOSTMIIMSEL_IN;
  assign #(in_delay) HOSTOPCODE_INDELAY = HOSTOPCODE_IN;
  assign #(in_delay) HOSTREQ_INDELAY = HOSTREQ_IN;
  assign #(in_delay) HOSTWRDATA_INDELAY = HOSTWRDATA_IN;
  assign #(in_delay) PHYEMACCOL_INDELAY = PHYEMACCOL_IN;
  assign #(in_delay) PHYEMACCRS_INDELAY = PHYEMACCRS_IN;
  assign #(in_delay) PHYEMACMDIN_INDELAY = PHYEMACMDIN_IN;
  assign #(in_delay) PHYEMACPHYAD_INDELAY = PHYEMACPHYAD_IN;
  assign #(in_delay) PHYEMACRXBUFSTATUS_INDELAY = PHYEMACRXBUFSTATUS_IN;
  assign #(in_delay) PHYEMACRXCHARISCOMMA_INDELAY = PHYEMACRXCHARISCOMMA_IN;
  assign #(in_delay) PHYEMACRXCHARISK_INDELAY = PHYEMACRXCHARISK_IN;
  assign #(in_delay) PHYEMACRXCLKCORCNT_INDELAY = PHYEMACRXCLKCORCNT_IN;
  assign #(in_delay) PHYEMACRXDISPERR_INDELAY = PHYEMACRXDISPERR_IN;
  assign #(in_delay) PHYEMACRXDV_INDELAY = PHYEMACRXDV_IN;
  assign #(in_delay) PHYEMACRXD_INDELAY = PHYEMACRXD_IN;
  assign #(in_delay) PHYEMACRXER_INDELAY = PHYEMACRXER_IN;
  assign #(in_delay) PHYEMACRXNOTINTABLE_INDELAY = PHYEMACRXNOTINTABLE_IN;
  assign #(in_delay) PHYEMACRXRUNDISP_INDELAY = PHYEMACRXRUNDISP_IN;
  assign #(in_delay) PHYEMACSIGNALDET_INDELAY = PHYEMACSIGNALDET_IN;
  assign #(in_delay) PHYEMACTXBUFERR_INDELAY = PHYEMACTXBUFERR_IN;
  assign #(in_delay) RESET_INDELAY = RESET_IN;

  assign delay_CLIENTEMACRXCLIENTCLKIN = CLIENTEMACRXCLIENTCLKIN_INDELAY;
  assign delay_RESET = RESET_INDELAY;
   
 B_TEMAC_SINGLE #(
    .EMAC_1000BASEX_ENABLE (EMAC_1000BASEX_ENABLE),
    .EMAC_ADDRFILTER_ENABLE (EMAC_ADDRFILTER_ENABLE),
    .EMAC_BYTEPHY (EMAC_BYTEPHY),
    .EMAC_CTRLLENCHECK_DISABLE (EMAC_CTRLLENCHECK_DISABLE),
    .EMAC_DCRBASEADDR (EMAC_DCRBASEADDR),
    .EMAC_GTLOOPBACK (EMAC_GTLOOPBACK),
    .EMAC_HOST_ENABLE (EMAC_HOST_ENABLE),
    .EMAC_LINKTIMERVAL (EMAC_LINKTIMERVAL),
    .EMAC_LTCHECK_DISABLE (EMAC_LTCHECK_DISABLE),
    .EMAC_MDIO_ENABLE (EMAC_MDIO_ENABLE),
    .EMAC_MDIO_IGNORE_PHYADZERO (EMAC_MDIO_IGNORE_PHYADZERO),
    .EMAC_PAUSEADDR (EMAC_PAUSEADDR),
    .EMAC_PHYINITAUTONEG_ENABLE (EMAC_PHYINITAUTONEG_ENABLE),
    .EMAC_PHYISOLATE (EMAC_PHYISOLATE),
    .EMAC_PHYLOOPBACKMSB (EMAC_PHYLOOPBACKMSB),
    .EMAC_PHYPOWERDOWN (EMAC_PHYPOWERDOWN),
    .EMAC_PHYRESET (EMAC_PHYRESET),
    .EMAC_RGMII_ENABLE (EMAC_RGMII_ENABLE),
    .EMAC_RX16BITCLIENT_ENABLE (EMAC_RX16BITCLIENT_ENABLE),
    .EMAC_RXFLOWCTRL_ENABLE (EMAC_RXFLOWCTRL_ENABLE),
    .EMAC_RXHALFDUPLEX (EMAC_RXHALFDUPLEX),
    .EMAC_RXINBANDFCS_ENABLE (EMAC_RXINBANDFCS_ENABLE),
    .EMAC_RXJUMBOFRAME_ENABLE (EMAC_RXJUMBOFRAME_ENABLE),
    .EMAC_RXRESET (EMAC_RXRESET),
    .EMAC_RXVLAN_ENABLE (EMAC_RXVLAN_ENABLE),
    .EMAC_RX_ENABLE (EMAC_RX_ENABLE),
    .EMAC_SGMII_ENABLE (EMAC_SGMII_ENABLE),
    .EMAC_SPEED_LSB (EMAC_SPEED_LSB),
    .EMAC_SPEED_MSB (EMAC_SPEED_MSB),
    .EMAC_TX16BITCLIENT_ENABLE (EMAC_TX16BITCLIENT_ENABLE),
    .EMAC_TXFLOWCTRL_ENABLE (EMAC_TXFLOWCTRL_ENABLE),
    .EMAC_TXHALFDUPLEX (EMAC_TXHALFDUPLEX),
    .EMAC_TXIFGADJUST_ENABLE (EMAC_TXIFGADJUST_ENABLE),
    .EMAC_TXINBANDFCS_ENABLE (EMAC_TXINBANDFCS_ENABLE),
    .EMAC_TXJUMBOFRAME_ENABLE (EMAC_TXJUMBOFRAME_ENABLE),
    .EMAC_TXRESET (EMAC_TXRESET),
    .EMAC_TXVLAN_ENABLE (EMAC_TXVLAN_ENABLE),
    .EMAC_TX_ENABLE (EMAC_TX_ENABLE),
    .EMAC_UNICASTADDR (EMAC_UNICASTADDR),
    .EMAC_UNIDIRECTION_ENABLE (EMAC_UNIDIRECTION_ENABLE),
    .EMAC_USECLKEN (EMAC_USECLKEN))

   B_TEMAC_SINGLE_INST(
    .DCRHOSTDONEIR (delay_DCRHOSTDONEIR),
    .EMACCLIENTANINTERRUPT (delay_EMACCLIENTANINTERRUPT),
    .EMACCLIENTRXBADFRAME (delay_EMACCLIENTRXBADFRAME),
    .EMACCLIENTRXCLIENTCLKOUT (delay_EMACCLIENTRXCLIENTCLKOUT),
    .EMACCLIENTRXD (delay_EMACCLIENTRXD),
    .EMACCLIENTRXDVLD (delay_EMACCLIENTRXDVLD),
    .EMACCLIENTRXDVLDMSW (delay_EMACCLIENTRXDVLDMSW),
    .EMACCLIENTRXFRAMEDROP (delay_EMACCLIENTRXFRAMEDROP),
    .EMACCLIENTRXGOODFRAME (delay_EMACCLIENTRXGOODFRAME),
    .EMACCLIENTRXSTATS (delay_EMACCLIENTRXSTATS),
    .EMACCLIENTRXSTATSBYTEVLD (delay_EMACCLIENTRXSTATSBYTEVLD),
    .EMACCLIENTRXSTATSVLD (delay_EMACCLIENTRXSTATSVLD),
    .EMACCLIENTTXACK (delay_EMACCLIENTTXACK),
    .EMACCLIENTTXCLIENTCLKOUT (delay_EMACCLIENTTXCLIENTCLKOUT),
    .EMACCLIENTTXCOLLISION (delay_EMACCLIENTTXCOLLISION),
    .EMACCLIENTTXRETRANSMIT (delay_EMACCLIENTTXRETRANSMIT),
    .EMACCLIENTTXSTATS (delay_EMACCLIENTTXSTATS),
    .EMACCLIENTTXSTATSBYTEVLD (delay_EMACCLIENTTXSTATSBYTEVLD),
    .EMACCLIENTTXSTATSVLD (delay_EMACCLIENTTXSTATSVLD),
    .EMACDCRACK (delay_EMACDCRACK),
    .EMACDCRDBUS (delay_EMACDCRDBUS),
    .EMACPHYENCOMMAALIGN (delay_EMACPHYENCOMMAALIGN),
    .EMACPHYLOOPBACKMSB (delay_EMACPHYLOOPBACKMSB),
    .EMACPHYMCLKOUT (delay_EMACPHYMCLKOUT),
    .EMACPHYMDOUT (delay_EMACPHYMDOUT),
    .EMACPHYMDTRI (delay_EMACPHYMDTRI),
    .EMACPHYMGTRXRESET (delay_EMACPHYMGTRXRESET),
    .EMACPHYMGTTXRESET (delay_EMACPHYMGTTXRESET),
    .EMACPHYPOWERDOWN (delay_EMACPHYPOWERDOWN),
    .EMACPHYSYNCACQSTATUS (delay_EMACPHYSYNCACQSTATUS),
    .EMACPHYTXCHARDISPMODE (delay_EMACPHYTXCHARDISPMODE),
    .EMACPHYTXCHARDISPVAL (delay_EMACPHYTXCHARDISPVAL),
    .EMACPHYTXCHARISK (delay_EMACPHYTXCHARISK),
    .EMACPHYTXCLK (delay_EMACPHYTXCLK),
    .EMACPHYTXD (delay_EMACPHYTXD),
    .EMACPHYTXEN (delay_EMACPHYTXEN),
    .EMACPHYTXER (delay_EMACPHYTXER),
    .EMACPHYTXGMIIMIICLKOUT (delay_EMACPHYTXGMIIMIICLKOUT),
    .EMACSPEEDIS10100 (delay_EMACSPEEDIS10100),
    .HOSTMIIMRDY (delay_HOSTMIIMRDY),
    .HOSTRDDATA (delay_HOSTRDDATA),
    .CLIENTEMACDCMLOCKED (delay_CLIENTEMACDCMLOCKED),
    .CLIENTEMACPAUSEREQ (delay_CLIENTEMACPAUSEREQ),
    .CLIENTEMACPAUSEVAL (delay_CLIENTEMACPAUSEVAL),
    .CLIENTEMACRXCLIENTCLKIN (delay_CLIENTEMACRXCLIENTCLKIN),
    .CLIENTEMACTXCLIENTCLKIN (delay_CLIENTEMACTXCLIENTCLKIN),
    .CLIENTEMACTXD (delay_CLIENTEMACTXD),
    .CLIENTEMACTXDVLD (delay_CLIENTEMACTXDVLD),
    .CLIENTEMACTXDVLDMSW (delay_CLIENTEMACTXDVLDMSW),
    .CLIENTEMACTXFIRSTBYTE (delay_CLIENTEMACTXFIRSTBYTE),
    .CLIENTEMACTXIFGDELAY (delay_CLIENTEMACTXIFGDELAY),
    .CLIENTEMACTXUNDERRUN (delay_CLIENTEMACTXUNDERRUN),
    .DCREMACABUS (delay_DCREMACABUS),
    .DCREMACCLK (delay_DCREMACCLK),
    .DCREMACDBUS (delay_DCREMACDBUS),
    .DCREMACENABLE (delay_DCREMACENABLE),
    .DCREMACREAD (delay_DCREMACREAD),
    .DCREMACWRITE (delay_DCREMACWRITE),
    .HOSTADDR (delay_HOSTADDR),
    .HOSTCLK (delay_HOSTCLK),
    .HOSTMIIMSEL (delay_HOSTMIIMSEL),
    .HOSTOPCODE (delay_HOSTOPCODE),
    .HOSTREQ (delay_HOSTREQ),
    .HOSTWRDATA (delay_HOSTWRDATA),
    .PHYEMACCOL (delay_PHYEMACCOL),
    .PHYEMACCRS (delay_PHYEMACCRS),
    .PHYEMACGTXCLK (delay_PHYEMACGTXCLK),
    .PHYEMACMCLKIN (delay_PHYEMACMCLKIN),
    .PHYEMACMDIN (delay_PHYEMACMDIN),
//    .PHYEMACMIITXCLK (delay_PHYEMACMIITXCLK),
    .PHYEMACMIITXCLK (PHYEMACMIITXCLK_ADDED),
    .PHYEMACPHYAD (delay_PHYEMACPHYAD),
    .PHYEMACRXBUFSTATUS (delay_PHYEMACRXBUFSTATUS),
    .PHYEMACRXCHARISCOMMA (delay_PHYEMACRXCHARISCOMMA),
    .PHYEMACRXCHARISK (delay_PHYEMACRXCHARISK),
    .PHYEMACRXCLK (delay_PHYEMACRXCLK),
    .PHYEMACRXCLKCORCNT (delay_PHYEMACRXCLKCORCNT),
    .PHYEMACRXD (delay_PHYEMACRXD),
    .PHYEMACRXDISPERR (delay_PHYEMACRXDISPERR),
    .PHYEMACRXDV (delay_PHYEMACRXDV),
    .PHYEMACRXER (delay_PHYEMACRXER),
    .PHYEMACRXNOTINTABLE (delay_PHYEMACRXNOTINTABLE),
    .PHYEMACRXRUNDISP (delay_PHYEMACRXRUNDISP),
    .PHYEMACSIGNALDET (delay_PHYEMACSIGNALDET),
    .PHYEMACTXBUFERR (delay_PHYEMACTXBUFERR),
    .PHYEMACTXGMIIMIICLKIN (delay_PHYEMACTXGMIIMIICLKIN),
    .RESET (delay_RESET),
    .GSR(GSR)
  );

  specify
    $recrem ( negedge RESET, posedge CLIENTEMACTXCLIENTCLKIN, 0:0:0, 0:0:0);
    $recrem ( negedge RESET, posedge HOSTCLK, 0:0:0, 0:0:0);
    $recrem ( negedge RESET, posedge PHYEMACGTXCLK, 0:0:0, 0:0:0);
    $recrem ( negedge RESET, posedge PHYEMACMIITXCLK, 0:0:0, 0:0:0);
    $recrem ( negedge RESET, posedge PHYEMACTXGMIIMIICLKIN, 0:0:0, 0:0:0);
    $recrem ( posedge RESET, posedge CLIENTEMACTXCLIENTCLKIN, 0:0:0, 0:0:0);
    $recrem ( posedge RESET, posedge HOSTCLK, 0:0:0, 0:0:0);
    $recrem ( posedge RESET, posedge PHYEMACGTXCLK, 0:0:0, 0:0:0);
    $recrem ( posedge RESET, posedge PHYEMACMIITXCLK, 0:0:0, 0:0:0);
    $recrem ( posedge RESET, posedge PHYEMACTXGMIIMIICLKIN, 0:0:0, 0:0:0);
    $setuphold (negedge PHYEMACRXCLK, negedge PHYEMACRXD[4], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[4]);
    $setuphold (negedge PHYEMACRXCLK, negedge PHYEMACRXD[5], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[5]);
    $setuphold (negedge PHYEMACRXCLK, negedge PHYEMACRXD[6], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[6]);
    $setuphold (negedge PHYEMACRXCLK, negedge PHYEMACRXD[7], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[7]);
    $setuphold (negedge PHYEMACRXCLK, negedge PHYEMACRXER, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXER);
    $setuphold (negedge PHYEMACRXCLK, posedge PHYEMACRXD[4], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[4]);
    $setuphold (negedge PHYEMACRXCLK, posedge PHYEMACRXD[5], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[5]);
    $setuphold (negedge PHYEMACRXCLK, posedge PHYEMACRXD[6], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[6]);
    $setuphold (negedge PHYEMACRXCLK, posedge PHYEMACRXD[7], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[7]);
    $setuphold (negedge PHYEMACRXCLK, posedge PHYEMACRXER, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXER);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACDCMLOCKED, 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACDCMLOCKED);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACPAUSEREQ, 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEREQ);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACPAUSEVAL[0], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[0]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACPAUSEVAL[10], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[10]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACPAUSEVAL[11], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[11]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACPAUSEVAL[12], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[12]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACPAUSEVAL[13], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[13]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACPAUSEVAL[14], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[14]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACPAUSEVAL[15], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[15]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACPAUSEVAL[1], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[1]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACPAUSEVAL[2], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[2]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACPAUSEVAL[3], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[3]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACPAUSEVAL[4], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[4]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACPAUSEVAL[5], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[5]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACPAUSEVAL[6], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[6]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACPAUSEVAL[7], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[7]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACPAUSEVAL[8], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[8]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACPAUSEVAL[9], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[9]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXDVLD, 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXDVLD);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXDVLDMSW, 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXDVLDMSW);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXD[0], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[0]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXD[10], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[10]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXD[11], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[11]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXD[12], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[12]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXD[13], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[13]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXD[14], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[14]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXD[15], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[15]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXD[1], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[1]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXD[2], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[2]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXD[3], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[3]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXD[4], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[4]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXD[5], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[5]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXD[6], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[6]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXD[7], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[7]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXD[8], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[8]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXD[9], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[9]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXFIRSTBYTE, 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXFIRSTBYTE);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXIFGDELAY[0], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXIFGDELAY[0]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXIFGDELAY[1], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXIFGDELAY[1]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXIFGDELAY[2], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXIFGDELAY[2]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXIFGDELAY[3], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXIFGDELAY[3]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXIFGDELAY[4], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXIFGDELAY[4]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXIFGDELAY[5], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXIFGDELAY[5]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXIFGDELAY[6], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXIFGDELAY[6]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXIFGDELAY[7], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXIFGDELAY[7]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, negedge CLIENTEMACTXUNDERRUN, 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXUNDERRUN);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACDCMLOCKED, 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACDCMLOCKED);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACPAUSEREQ, 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEREQ);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACPAUSEVAL[0], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[0]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACPAUSEVAL[10], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[10]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACPAUSEVAL[11], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[11]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACPAUSEVAL[12], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[12]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACPAUSEVAL[13], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[13]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACPAUSEVAL[14], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[14]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACPAUSEVAL[15], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[15]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACPAUSEVAL[1], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[1]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACPAUSEVAL[2], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[2]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACPAUSEVAL[3], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[3]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACPAUSEVAL[4], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[4]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACPAUSEVAL[5], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[5]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACPAUSEVAL[6], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[6]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACPAUSEVAL[7], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[7]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACPAUSEVAL[8], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[8]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACPAUSEVAL[9], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACPAUSEVAL[9]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXDVLD, 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXDVLD);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXDVLDMSW, 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXDVLDMSW);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXD[0], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[0]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXD[10], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[10]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXD[11], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[11]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXD[12], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[12]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXD[13], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[13]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXD[14], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[14]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXD[15], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[15]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXD[1], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[1]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXD[2], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[2]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXD[3], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[3]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXD[4], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[4]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXD[5], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[5]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXD[6], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[6]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXD[7], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[7]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXD[8], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[8]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXD[9], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXD[9]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXFIRSTBYTE, 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXFIRSTBYTE);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXIFGDELAY[0], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXIFGDELAY[0]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXIFGDELAY[1], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXIFGDELAY[1]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXIFGDELAY[2], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXIFGDELAY[2]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXIFGDELAY[3], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXIFGDELAY[3]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXIFGDELAY[4], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXIFGDELAY[4]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXIFGDELAY[5], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXIFGDELAY[5]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXIFGDELAY[6], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXIFGDELAY[6]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXIFGDELAY[7], 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXIFGDELAY[7]);
    $setuphold (posedge CLIENTEMACTXCLIENTCLKIN, posedge CLIENTEMACTXUNDERRUN, 0:0:0, 0:0:0, notifier,,, delay_CLIENTEMACTXCLIENTCLKIN, delay_CLIENTEMACTXUNDERRUN);
    $setuphold (posedge DCREMACCLK, negedge DCREMACABUS[0], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[0]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACABUS[1], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[1]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACABUS[2], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[2]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACABUS[3], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[3]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACABUS[4], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[4]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACABUS[5], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[5]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACABUS[6], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[6]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACABUS[7], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[7]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACABUS[8], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[8]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACABUS[9], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[9]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[0], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[0]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[10], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[10]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[11], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[11]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[12], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[12]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[13], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[13]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[14], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[14]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[15], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[15]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[16], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[16]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[17], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[17]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[18], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[18]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[19], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[19]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[1], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[1]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[20], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[20]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[21], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[21]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[22], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[22]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[23], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[23]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[24], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[24]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[25], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[25]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[26], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[26]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[27], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[27]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[28], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[28]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[29], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[29]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[2], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[2]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[30], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[30]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[31], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[31]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[3], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[3]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[4], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[4]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[5], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[5]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[6], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[6]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[7], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[7]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[8], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[8]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACDBUS[9], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[9]);
    $setuphold (posedge DCREMACCLK, negedge DCREMACENABLE, 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACENABLE);
    $setuphold (posedge DCREMACCLK, negedge DCREMACREAD, 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACREAD);
    $setuphold (posedge DCREMACCLK, negedge DCREMACWRITE, 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACWRITE);
    $setuphold (posedge DCREMACCLK, posedge DCREMACABUS[0], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[0]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACABUS[1], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[1]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACABUS[2], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[2]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACABUS[3], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[3]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACABUS[4], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[4]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACABUS[5], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[5]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACABUS[6], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[6]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACABUS[7], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[7]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACABUS[8], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[8]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACABUS[9], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACABUS[9]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[0], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[0]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[10], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[10]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[11], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[11]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[12], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[12]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[13], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[13]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[14], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[14]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[15], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[15]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[16], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[16]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[17], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[17]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[18], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[18]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[19], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[19]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[1], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[1]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[20], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[20]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[21], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[21]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[22], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[22]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[23], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[23]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[24], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[24]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[25], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[25]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[26], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[26]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[27], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[27]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[28], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[28]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[29], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[29]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[2], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[2]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[30], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[30]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[31], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[31]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[3], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[3]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[4], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[4]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[5], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[5]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[6], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[6]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[7], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[7]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[8], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[8]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACDBUS[9], 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACDBUS[9]);
    $setuphold (posedge DCREMACCLK, posedge DCREMACENABLE, 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACENABLE);
    $setuphold (posedge DCREMACCLK, posedge DCREMACREAD, 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACREAD);
    $setuphold (posedge DCREMACCLK, posedge DCREMACWRITE, 0:0:0, 0:0:0, notifier,,, delay_DCREMACCLK, delay_DCREMACWRITE);
    $setuphold (posedge HOSTCLK, negedge HOSTADDR[0], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[0]);
    $setuphold (posedge HOSTCLK, negedge HOSTADDR[1], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[1]);
    $setuphold (posedge HOSTCLK, negedge HOSTADDR[2], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[2]);
    $setuphold (posedge HOSTCLK, negedge HOSTADDR[3], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[3]);
    $setuphold (posedge HOSTCLK, negedge HOSTADDR[4], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[4]);
    $setuphold (posedge HOSTCLK, negedge HOSTADDR[5], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[5]);
    $setuphold (posedge HOSTCLK, negedge HOSTADDR[6], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[6]);
    $setuphold (posedge HOSTCLK, negedge HOSTADDR[7], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[7]);
    $setuphold (posedge HOSTCLK, negedge HOSTADDR[8], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[8]);
    $setuphold (posedge HOSTCLK, negedge HOSTADDR[9], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[9]);
    $setuphold (posedge HOSTCLK, negedge HOSTMIIMSEL, 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTMIIMSEL);
    $setuphold (posedge HOSTCLK, negedge HOSTOPCODE[0], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTOPCODE[0]);
    $setuphold (posedge HOSTCLK, negedge HOSTOPCODE[1], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTOPCODE[1]);
    $setuphold (posedge HOSTCLK, negedge HOSTREQ, 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTREQ);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[0], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[0]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[10], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[10]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[11], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[11]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[12], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[12]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[13], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[13]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[14], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[14]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[15], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[15]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[16], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[16]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[17], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[17]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[18], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[18]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[19], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[19]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[1], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[1]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[20], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[20]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[21], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[21]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[22], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[22]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[23], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[23]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[24], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[24]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[25], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[25]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[26], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[26]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[27], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[27]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[28], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[28]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[29], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[29]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[2], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[2]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[30], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[30]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[31], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[31]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[3], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[3]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[4], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[4]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[5], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[5]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[6], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[6]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[7], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[7]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[8], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[8]);
    $setuphold (posedge HOSTCLK, negedge HOSTWRDATA[9], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[9]);
    $setuphold (posedge HOSTCLK, negedge PHYEMACMDIN, 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_PHYEMACMDIN);
    $setuphold (posedge HOSTCLK, negedge PHYEMACPHYAD[0], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_PHYEMACPHYAD[0]);
    $setuphold (posedge HOSTCLK, negedge PHYEMACPHYAD[1], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_PHYEMACPHYAD[1]);
    $setuphold (posedge HOSTCLK, negedge PHYEMACPHYAD[2], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_PHYEMACPHYAD[2]);
    $setuphold (posedge HOSTCLK, negedge PHYEMACPHYAD[3], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_PHYEMACPHYAD[3]);
    $setuphold (posedge HOSTCLK, negedge PHYEMACPHYAD[4], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_PHYEMACPHYAD[4]);
    $setuphold (posedge HOSTCLK, posedge HOSTADDR[0], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[0]);
    $setuphold (posedge HOSTCLK, posedge HOSTADDR[1], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[1]);
    $setuphold (posedge HOSTCLK, posedge HOSTADDR[2], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[2]);
    $setuphold (posedge HOSTCLK, posedge HOSTADDR[3], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[3]);
    $setuphold (posedge HOSTCLK, posedge HOSTADDR[4], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[4]);
    $setuphold (posedge HOSTCLK, posedge HOSTADDR[5], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[5]);
    $setuphold (posedge HOSTCLK, posedge HOSTADDR[6], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[6]);
    $setuphold (posedge HOSTCLK, posedge HOSTADDR[7], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[7]);
    $setuphold (posedge HOSTCLK, posedge HOSTADDR[8], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[8]);
    $setuphold (posedge HOSTCLK, posedge HOSTADDR[9], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTADDR[9]);
    $setuphold (posedge HOSTCLK, posedge HOSTMIIMSEL, 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTMIIMSEL);
    $setuphold (posedge HOSTCLK, posedge HOSTOPCODE[0], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTOPCODE[0]);
    $setuphold (posedge HOSTCLK, posedge HOSTOPCODE[1], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTOPCODE[1]);
    $setuphold (posedge HOSTCLK, posedge HOSTREQ, 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTREQ);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[0], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[0]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[10], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[10]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[11], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[11]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[12], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[12]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[13], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[13]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[14], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[14]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[15], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[15]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[16], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[16]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[17], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[17]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[18], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[18]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[19], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[19]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[1], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[1]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[20], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[20]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[21], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[21]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[22], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[22]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[23], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[23]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[24], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[24]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[25], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[25]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[26], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[26]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[27], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[27]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[28], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[28]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[29], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[29]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[2], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[2]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[30], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[30]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[31], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[31]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[3], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[3]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[4], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[4]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[5], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[5]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[6], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[6]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[7], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[7]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[8], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[8]);
    $setuphold (posedge HOSTCLK, posedge HOSTWRDATA[9], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_HOSTWRDATA[9]);
    $setuphold (posedge HOSTCLK, posedge PHYEMACMDIN, 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_PHYEMACMDIN);
    $setuphold (posedge HOSTCLK, posedge PHYEMACPHYAD[0], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_PHYEMACPHYAD[0]);
    $setuphold (posedge HOSTCLK, posedge PHYEMACPHYAD[1], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_PHYEMACPHYAD[1]);
    $setuphold (posedge HOSTCLK, posedge PHYEMACPHYAD[2], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_PHYEMACPHYAD[2]);
    $setuphold (posedge HOSTCLK, posedge PHYEMACPHYAD[3], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_PHYEMACPHYAD[3]);
    $setuphold (posedge HOSTCLK, posedge PHYEMACPHYAD[4], 0:0:0, 0:0:0, notifier,,, delay_HOSTCLK, delay_PHYEMACPHYAD[4]);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACCOL, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACCOL);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACCRS, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACCRS);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXBUFSTATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXBUFSTATUS[0]);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXBUFSTATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXBUFSTATUS[1]);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXCHARISCOMMA, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXCHARISCOMMA);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXCHARISK, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXCHARISK);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXCLKCORCNT[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXCLKCORCNT[0]);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXCLKCORCNT[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXCLKCORCNT[1]);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXCLKCORCNT[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXCLKCORCNT[2]);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXDISPERR, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXDISPERR);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXDV, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXDV);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXD[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXD[0]);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXD[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXD[1]);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXD[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXD[2]);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXD[3], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXD[3]);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXD[4], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXD[4]);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXD[5], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXD[5]);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXD[6], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXD[6]);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXD[7], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXD[7]);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXER, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXER);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXNOTINTABLE, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXNOTINTABLE);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACRXRUNDISP, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXRUNDISP);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACSIGNALDET, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACSIGNALDET);
    $setuphold (posedge PHYEMACGTXCLK, negedge PHYEMACTXBUFERR, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACTXBUFERR);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACCOL, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACCOL);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACCRS, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACCRS);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXBUFSTATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXBUFSTATUS[0]);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXBUFSTATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXBUFSTATUS[1]);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXCHARISCOMMA, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXCHARISCOMMA);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXCHARISK, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXCHARISK);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXCLKCORCNT[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXCLKCORCNT[0]);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXCLKCORCNT[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXCLKCORCNT[1]);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXCLKCORCNT[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXCLKCORCNT[2]);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXDISPERR, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXDISPERR);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXDV, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXDV);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXD[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXD[0]);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXD[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXD[1]);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXD[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXD[2]);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXD[3], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXD[3]);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXD[4], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXD[4]);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXD[5], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXD[5]);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXD[6], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXD[6]);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXD[7], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXD[7]);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXER, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXER);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXNOTINTABLE, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXNOTINTABLE);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACRXRUNDISP, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACRXRUNDISP);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACSIGNALDET, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACSIGNALDET);
    $setuphold (posedge PHYEMACGTXCLK, posedge PHYEMACTXBUFERR, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACGTXCLK, delay_PHYEMACTXBUFERR);
    $setuphold (posedge PHYEMACMCLKIN, negedge PHYEMACMDIN, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMCLKIN, delay_PHYEMACMDIN);
    $setuphold (posedge PHYEMACMCLKIN, posedge PHYEMACMDIN, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMCLKIN, delay_PHYEMACMDIN);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACDCMLOCKED, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACDCMLOCKED);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACPAUSEREQ, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEREQ);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACPAUSEVAL[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[0]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACPAUSEVAL[10], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[10]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACPAUSEVAL[11], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[11]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACPAUSEVAL[12], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[12]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACPAUSEVAL[13], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[13]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACPAUSEVAL[14], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[14]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACPAUSEVAL[15], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[15]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACPAUSEVAL[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[1]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACPAUSEVAL[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[2]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACPAUSEVAL[3], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[3]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACPAUSEVAL[4], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[4]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACPAUSEVAL[5], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[5]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACPAUSEVAL[6], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[6]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACPAUSEVAL[7], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[7]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACPAUSEVAL[8], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[8]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACPAUSEVAL[9], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[9]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXDVLD, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXDVLD);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXDVLDMSW, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXDVLDMSW);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXD[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[0]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXD[10], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[10]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXD[11], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[11]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXD[12], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[12]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXD[13], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[13]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXD[14], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[14]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXD[15], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[15]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXD[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[1]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXD[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[2]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXD[3], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[3]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXD[4], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[4]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXD[5], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[5]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXD[6], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[6]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXD[7], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[7]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXD[8], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[8]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXD[9], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[9]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXFIRSTBYTE, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXFIRSTBYTE);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXIFGDELAY[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXIFGDELAY[0]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXIFGDELAY[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXIFGDELAY[1]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXIFGDELAY[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXIFGDELAY[2]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXIFGDELAY[3], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXIFGDELAY[3]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXIFGDELAY[4], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXIFGDELAY[4]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXIFGDELAY[5], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXIFGDELAY[5]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXIFGDELAY[6], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXIFGDELAY[6]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXIFGDELAY[7], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXIFGDELAY[7]);
    $setuphold (posedge PHYEMACMIITXCLK, negedge CLIENTEMACTXUNDERRUN, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXUNDERRUN);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACDCMLOCKED, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACDCMLOCKED);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACPAUSEREQ, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEREQ);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACPAUSEVAL[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[0]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACPAUSEVAL[10], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[10]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACPAUSEVAL[11], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[11]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACPAUSEVAL[12], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[12]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACPAUSEVAL[13], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[13]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACPAUSEVAL[14], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[14]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACPAUSEVAL[15], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[15]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACPAUSEVAL[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[1]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACPAUSEVAL[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[2]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACPAUSEVAL[3], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[3]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACPAUSEVAL[4], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[4]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACPAUSEVAL[5], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[5]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACPAUSEVAL[6], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[6]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACPAUSEVAL[7], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[7]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACPAUSEVAL[8], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[8]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACPAUSEVAL[9], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACPAUSEVAL[9]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXDVLD, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXDVLD);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXDVLDMSW, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXDVLDMSW);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXD[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[0]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXD[10], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[10]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXD[11], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[11]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXD[12], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[12]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXD[13], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[13]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXD[14], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[14]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXD[15], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[15]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXD[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[1]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXD[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[2]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXD[3], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[3]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXD[4], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[4]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXD[5], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[5]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXD[6], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[6]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXD[7], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[7]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXD[8], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[8]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXD[9], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXD[9]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXFIRSTBYTE, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXFIRSTBYTE);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXIFGDELAY[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXIFGDELAY[0]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXIFGDELAY[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXIFGDELAY[1]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXIFGDELAY[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXIFGDELAY[2]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXIFGDELAY[3], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXIFGDELAY[3]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXIFGDELAY[4], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXIFGDELAY[4]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXIFGDELAY[5], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXIFGDELAY[5]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXIFGDELAY[6], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXIFGDELAY[6]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXIFGDELAY[7], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXIFGDELAY[7]);
    $setuphold (posedge PHYEMACMIITXCLK, posedge CLIENTEMACTXUNDERRUN, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACMIITXCLK, delay_CLIENTEMACTXUNDERRUN);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACCOL, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACCOL);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACCRS, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACCRS);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXBUFSTATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXBUFSTATUS[0]);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXBUFSTATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXBUFSTATUS[1]);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXCHARISCOMMA, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXCHARISCOMMA);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXCHARISK, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXCHARISK);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXCLKCORCNT[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXCLKCORCNT[0]);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXCLKCORCNT[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXCLKCORCNT[1]);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXCLKCORCNT[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXCLKCORCNT[2]);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXDISPERR, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXDISPERR);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXDV, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXDV);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXD[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[0]);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXD[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[1]);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXD[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[2]);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXD[3], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[3]);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXD[4], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[4]);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXD[5], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[5]);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXD[6], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[6]);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXD[7], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[7]);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXER, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXER);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXNOTINTABLE, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXNOTINTABLE);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACRXRUNDISP, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXRUNDISP);
    $setuphold (posedge PHYEMACRXCLK, negedge PHYEMACSIGNALDET, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACSIGNALDET);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACCOL, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACCOL);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACCRS, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACCRS);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXBUFSTATUS[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXBUFSTATUS[0]);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXBUFSTATUS[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXBUFSTATUS[1]);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXCHARISCOMMA, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXCHARISCOMMA);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXCHARISK, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXCHARISK);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXCLKCORCNT[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXCLKCORCNT[0]);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXCLKCORCNT[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXCLKCORCNT[1]);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXCLKCORCNT[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXCLKCORCNT[2]);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXDISPERR, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXDISPERR);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXDV, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXDV);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXD[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[0]);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXD[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[1]);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXD[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[2]);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXD[3], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[3]);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXD[4], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[4]);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXD[5], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[5]);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXD[6], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[6]);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXD[7], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXD[7]);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXER, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXER);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXNOTINTABLE, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXNOTINTABLE);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACRXRUNDISP, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACRXRUNDISP);
    $setuphold (posedge PHYEMACRXCLK, posedge PHYEMACSIGNALDET, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACRXCLK, delay_PHYEMACSIGNALDET);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACDCMLOCKED, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACDCMLOCKED);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACPAUSEREQ, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEREQ);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACPAUSEVAL[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[0]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACPAUSEVAL[10], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[10]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACPAUSEVAL[11], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[11]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACPAUSEVAL[12], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[12]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACPAUSEVAL[13], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[13]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACPAUSEVAL[14], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[14]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACPAUSEVAL[15], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[15]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACPAUSEVAL[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[1]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACPAUSEVAL[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[2]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACPAUSEVAL[3], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[3]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACPAUSEVAL[4], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[4]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACPAUSEVAL[5], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[5]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACPAUSEVAL[6], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[6]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACPAUSEVAL[7], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[7]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACPAUSEVAL[8], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[8]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACPAUSEVAL[9], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[9]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXDVLD, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXDVLD);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXDVLDMSW, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXDVLDMSW);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXD[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[0]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXD[10], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[10]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXD[11], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[11]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXD[12], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[12]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXD[13], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[13]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXD[14], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[14]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXD[15], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[15]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXD[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[1]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXD[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[2]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXD[3], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[3]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXD[4], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[4]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXD[5], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[5]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXD[6], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[6]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXD[7], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[7]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXD[8], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[8]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXD[9], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[9]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXFIRSTBYTE, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXFIRSTBYTE);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXIFGDELAY[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXIFGDELAY[0]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXIFGDELAY[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXIFGDELAY[1]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXIFGDELAY[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXIFGDELAY[2]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXIFGDELAY[3], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXIFGDELAY[3]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXIFGDELAY[4], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXIFGDELAY[4]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXIFGDELAY[5], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXIFGDELAY[5]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXIFGDELAY[6], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXIFGDELAY[6]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXIFGDELAY[7], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXIFGDELAY[7]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge CLIENTEMACTXUNDERRUN, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXUNDERRUN);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, negedge PHYEMACTXBUFERR, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_PHYEMACTXBUFERR);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACDCMLOCKED, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACDCMLOCKED);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACPAUSEREQ, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEREQ);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACPAUSEVAL[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[0]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACPAUSEVAL[10], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[10]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACPAUSEVAL[11], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[11]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACPAUSEVAL[12], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[12]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACPAUSEVAL[13], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[13]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACPAUSEVAL[14], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[14]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACPAUSEVAL[15], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[15]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACPAUSEVAL[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[1]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACPAUSEVAL[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[2]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACPAUSEVAL[3], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[3]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACPAUSEVAL[4], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[4]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACPAUSEVAL[5], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[5]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACPAUSEVAL[6], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[6]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACPAUSEVAL[7], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[7]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACPAUSEVAL[8], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[8]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACPAUSEVAL[9], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACPAUSEVAL[9]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXDVLD, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXDVLD);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXDVLDMSW, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXDVLDMSW);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXD[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[0]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXD[10], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[10]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXD[11], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[11]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXD[12], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[12]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXD[13], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[13]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXD[14], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[14]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXD[15], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[15]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXD[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[1]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXD[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[2]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXD[3], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[3]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXD[4], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[4]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXD[5], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[5]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXD[6], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[6]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXD[7], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[7]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXD[8], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[8]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXD[9], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXD[9]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXFIRSTBYTE, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXFIRSTBYTE);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXIFGDELAY[0], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXIFGDELAY[0]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXIFGDELAY[1], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXIFGDELAY[1]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXIFGDELAY[2], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXIFGDELAY[2]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXIFGDELAY[3], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXIFGDELAY[3]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXIFGDELAY[4], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXIFGDELAY[4]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXIFGDELAY[5], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXIFGDELAY[5]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXIFGDELAY[6], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXIFGDELAY[6]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXIFGDELAY[7], 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXIFGDELAY[7]);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge CLIENTEMACTXUNDERRUN, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_CLIENTEMACTXUNDERRUN);
    $setuphold (posedge PHYEMACTXGMIIMIICLKIN, posedge PHYEMACTXBUFERR, 0:0:0, 0:0:0, notifier,,, delay_PHYEMACTXGMIIMIICLKIN, delay_PHYEMACTXBUFERR);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXBADFRAME) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXCLIENTCLKOUT) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXDVLD) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXDVLDMSW) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXD[0]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXD[10]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXD[11]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXD[12]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXD[13]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXD[14]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXD[15]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXD[1]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXD[2]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXD[3]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXD[4]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXD[5]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXD[6]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXD[7]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXD[8]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXD[9]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXFRAMEDROP) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXGOODFRAME) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXSTATSBYTEVLD) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXSTATSVLD) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXSTATS[0]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXSTATS[1]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXSTATS[2]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXSTATS[3]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXSTATS[4]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXSTATS[5]) = (100:100:100, 100:100:100);
    ( CLIENTEMACRXCLIENTCLKIN => EMACCLIENTRXSTATS[6]) = (100:100:100, 100:100:100);
    ( CLIENTEMACTXCLIENTCLKIN => EMACCLIENTTXACK) = (100:100:100, 100:100:100);
    ( CLIENTEMACTXCLIENTCLKIN => EMACCLIENTTXCOLLISION) = (100:100:100, 100:100:100);
    ( CLIENTEMACTXCLIENTCLKIN => EMACCLIENTTXRETRANSMIT) = (100:100:100, 100:100:100);
    ( CLIENTEMACTXCLIENTCLKIN => EMACCLIENTTXSTATS) = (100:100:100, 100:100:100);
    ( CLIENTEMACTXCLIENTCLKIN => EMACCLIENTTXSTATSBYTEVLD) = (100:100:100, 100:100:100);
    ( CLIENTEMACTXCLIENTCLKIN => EMACCLIENTTXSTATSVLD) = (100:100:100, 100:100:100);
    ( DCREMACCLK => DCRHOSTDONEIR) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRACK) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[0]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[10]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[11]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[12]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[13]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[14]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[15]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[16]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[17]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[18]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[19]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[1]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[20]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[21]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[22]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[23]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[24]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[25]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[26]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[27]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[28]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[29]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[2]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[30]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[31]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[3]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[4]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[5]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[6]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[7]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[8]) = (100:100:100, 100:100:100);
    ( DCREMACCLK => EMACDCRDBUS[9]) = (100:100:100, 100:100:100);
    ( HOSTCLK => EMACPHYMCLKOUT) = (100:100:100, 100:100:100);
    ( HOSTCLK => EMACPHYMDOUT) = (100:100:100, 100:100:100);
    ( HOSTCLK => EMACPHYMDTRI) = (100:100:100, 100:100:100);
    ( HOSTCLK => EMACSPEEDIS10100) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTMIIMRDY) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[0]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[10]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[11]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[12]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[13]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[14]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[15]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[16]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[17]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[18]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[19]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[1]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[20]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[21]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[22]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[23]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[24]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[25]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[26]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[27]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[28]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[29]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[2]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[30]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[31]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[3]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[4]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[5]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[6]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[7]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[8]) = (100:100:100, 100:100:100);
    ( HOSTCLK => HOSTRDDATA[9]) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACCLIENTANINTERRUPT) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACCLIENTRXCLIENTCLKOUT) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACCLIENTTXCLIENTCLKOUT) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYENCOMMAALIGN) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYLOOPBACKMSB) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYMGTRXRESET) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYMGTTXRESET) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYPOWERDOWN) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYSYNCACQSTATUS) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYTXCHARDISPMODE) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYTXCHARDISPVAL) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYTXCHARISK) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYTXCLK) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYTXD[0]) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYTXD[1]) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYTXD[2]) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYTXD[3]) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYTXD[4]) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYTXD[5]) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYTXD[6]) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYTXD[7]) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYTXEN) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYTXER) = (100:100:100, 100:100:100);
    ( PHYEMACGTXCLK => EMACPHYTXGMIIMIICLKOUT) = (100:100:100, 100:100:100);
    ( PHYEMACMCLKIN => EMACPHYMCLKOUT) = (100:100:100, 100:100:100);
    ( PHYEMACMCLKIN => EMACPHYMDOUT) = (100:100:100, 100:100:100);
    ( PHYEMACMCLKIN => EMACPHYMDTRI) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXBADFRAME) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXCLIENTCLKOUT) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXDVLD) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXDVLDMSW) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXD[0]) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXD[10]) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXD[11]) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXD[12]) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXD[13]) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXD[14]) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXD[15]) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXD[1]) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXD[2]) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXD[3]) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXD[4]) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXD[5]) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXD[6]) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXD[7]) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXD[8]) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXD[9]) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXFRAMEDROP) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTRXGOODFRAME) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTTXACK) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTTXCLIENTCLKOUT) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTTXCOLLISION) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACCLIENTTXRETRANSMIT) = (100:100:100, 100:100:100);
    ( PHYEMACMIITXCLK => EMACPHYTXGMIIMIICLKOUT) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXBADFRAME) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXCLIENTCLKOUT) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXDVLD) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXDVLDMSW) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXD[0]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXD[10]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXD[11]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXD[12]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXD[13]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXD[14]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXD[15]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXD[1]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXD[2]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXD[3]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXD[4]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXD[5]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXD[6]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXD[7]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXD[8]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXD[9]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXFRAMEDROP) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXGOODFRAME) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXSTATSBYTEVLD) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXSTATSVLD) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXSTATS[0]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXSTATS[1]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXSTATS[2]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXSTATS[3]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXSTATS[4]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXSTATS[5]) = (100:100:100, 100:100:100);
    ( PHYEMACRXCLK => EMACCLIENTRXSTATS[6]) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACCLIENTTXACK) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACCLIENTTXCLIENTCLKOUT) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACCLIENTTXCOLLISION) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACCLIENTTXRETRANSMIT) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACCLIENTTXSTATS) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACCLIENTTXSTATSBYTEVLD) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACCLIENTTXSTATSVLD) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACPHYSYNCACQSTATUS) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACPHYTXCHARDISPMODE) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACPHYTXCHARDISPVAL) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACPHYTXCHARISK) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACPHYTXCLK) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACPHYTXD[0]) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACPHYTXD[1]) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACPHYTXD[2]) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACPHYTXD[3]) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACPHYTXD[4]) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACPHYTXD[5]) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACPHYTXD[6]) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACPHYTXD[7]) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACPHYTXEN) = (100:100:100, 100:100:100);
    ( PHYEMACTXGMIIMIICLKIN => EMACPHYTXER) = (100:100:100, 100:100:100);

    specparam PATHPULSE$ = 0;
  endspecify
endmodule
